/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsReadInventory {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryFullTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        for (int i = 0; i < 27; ++i) {
            chest.setItem(i, new ItemStack((ItemLike)Items.COAL));
        }
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.BOOLEAN_FULL, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryFullFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        for (int i = 0; i < 26; ++i) {
            chest.setItem(i, new ItemStack((ItemLike)Items.COAL));
        }
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.BOOLEAN_FULL, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryEmptyTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.BOOLEAN_EMPTY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryEmptyFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chest.setItem(0, new ItemStack((ItemLike)Items.COAL));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.BOOLEAN_EMPTY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryNonEmptyTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chest.setItem(0, new ItemStack((ItemLike)Items.COAL));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.BOOLEAN_NONEMPTY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryNonEmptyFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.BOOLEAN_NONEMPTY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryApplicableTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.BOOLEAN_APPLICABLE, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryApplicableFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.BOOLEAN_APPLICABLE, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryCount(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chest.setItem(0, new ItemStack((ItemLike)Items.COAL, 10));
        chest.setItem(1, new ItemStack((ItemLike)Items.COAL, 5));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.INTEGER_COUNT, ValueTypeInteger.ValueInteger.of(15));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventorySlotsValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.INTEGER_SLOTS, ValueTypeInteger.ValueInteger.of(27));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventorySlotsInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.INTEGER_SLOTS, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventorySlotsFilled(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chest.setItem(0, new ItemStack((ItemLike)Items.COAL, 10));
        chest.setItem(1, new ItemStack((ItemLike)Items.COAL, 5));
        chest.setItem(10, new ItemStack((ItemLike)Items.COAL, 5));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.INTEGER_SLOTSFILLED, ValueTypeInteger.ValueInteger.of(3));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryFillRatio(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chest.setItem(0, new ItemStack((ItemLike)Items.COAL, 10));
        chest.setItem(1, new ItemStack((ItemLike)Items.COAL, 5));
        chest.setItem(10, new ItemStack((ItemLike)Items.COAL, 5));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.DOUBLE_FILLRATIO, ValueTypeDouble.ValueDouble.of(0.1111111111111111));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadInventoryItemStacks(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chest.setItem(0, new ItemStack((ItemLike)Items.COAL, 10));
        chest.setItem(1, new ItemStack((ItemLike)Items.COAL, 5));
        chest.setItem(10, new ItemStack((ItemLike)Items.COAL, 5));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.INVENTORY_READER, Aspects.Read.Inventory.LIST_ITEMSTACKS, ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeItemStack.ValueItemStack[]{ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.COAL, 10)), ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.COAL, 5)), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.COAL, 5)), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY), ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY)}));
    }
}

