/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import com.google.common.collect.Sets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.item.ItemFacade;

public class GameTestsFacades {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(1, 1, 1);

    @GameTest(template="integrateddynamics:empty10")
    public void testFacadeCable(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStackFacade = new ItemStack((ItemLike)RegistryEntries.ITEM_FACADE.value());
        ((ItemFacade)((Object)RegistryEntries.ITEM_FACADE.value())).writeFacadeBlock(itemStackFacade, Blocks.COPPER_BLOCK.defaultBlockState());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackFacade);
        helper.placeAt(player, itemStackFacade, POS.south(), Direction.NORTH);
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1 != null, (Component)Component.literal((String)"Network is null"));
            helper.assertTrue(CableHelpers.hasFacade((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), helper.getBlockState(POS)), (Component)Component.literal((String)"Facade is not present"));
            helper.assertValueEqual((Object)CableHelpers.getFacade((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), helper.getBlockState(POS)).get(), (Object)Blocks.COPPER_BLOCK.defaultBlockState(), (Component)Component.literal((String)"Facade type is incorrect"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testFacadeCablesConnect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStackFacade = new ItemStack((ItemLike)RegistryEntries.ITEM_FACADE.value());
        ((ItemFacade)((Object)RegistryEntries.ITEM_FACADE.value())).writeFacadeBlock(itemStackFacade, Blocks.COPPER_BLOCK.defaultBlockState());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackFacade);
        helper.placeAt(player, itemStackFacade, POS.south(), Direction.NORTH);
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.south().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south().east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south().east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST, Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertTrue(CableHelpers.hasFacade((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), helper.getBlockState(POS)), (Component)Component.literal((String)"Facade is not present"));
            helper.assertValueEqual((Object)CableHelpers.getFacade((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), helper.getBlockState(POS)).get(), (Object)Blocks.COPPER_BLOCK.defaultBlockState(), (Component)Component.literal((String)"Facade type is incorrect"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testFacadeCableWithPart(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStackFacade = new ItemStack((ItemLike)RegistryEntries.ITEM_FACADE.value());
        ((ItemFacade)((Object)RegistryEntries.ITEM_FACADE.value())).writeFacadeBlock(itemStackFacade, Blocks.COPPER_BLOCK.defaultBlockState());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackFacade);
        helper.placeAt(player, itemStackFacade, POS.south(), Direction.NORTH);
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1 != null, (Component)Component.literal((String)"Network is null"));
            helper.assertTrue(CableHelpers.hasFacade((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), helper.getBlockState(POS)), (Component)Component.literal((String)"Facade is not present"));
            helper.assertValueEqual((Object)CableHelpers.getFacade((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), helper.getBlockState(POS)).get(), (Object)Blocks.COPPER_BLOCK.defaultBlockState(), (Component)Component.literal((String)"Facade type is incorrect"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testFacadeCableWithLever(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStackFacade = new ItemStack((ItemLike)RegistryEntries.ITEM_FACADE.value());
        ((ItemFacade)((Object)RegistryEntries.ITEM_FACADE.value())).writeFacadeBlock(itemStackFacade, Blocks.COPPER_BLOCK.defaultBlockState());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackFacade);
        helper.placeAt(player, itemStackFacade, POS.south(), Direction.NORTH);
        ItemStack itemStack = new ItemStack((ItemLike)Items.LEVER);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.south(), Direction.NORTH);
        helper.succeedWhen(() -> {
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty(), (Component)Component.literal((String)"Item hand is not empty"));
            helper.assertBlockPresent(Blocks.LEVER, POS.north());
        });
    }
}

