/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import com.google.common.collect.Sets;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;

public class GameTestsNetwork {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(1, 1, 1);

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkSingle(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.south().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south().east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south().east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST, Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkSingleByPlayer(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.BLOCK_CABLE.value(), 4);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.south(), Direction.NORTH);
        helper.placeAt(player, itemStack, POS.south().south(), Direction.NORTH);
        helper.placeAt(player, itemStack, POS.south().east(), Direction.NORTH);
        helper.placeAt(player, itemStack, POS.south().south().east(), Direction.NORTH);
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south().east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south().east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST, Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkTwo(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(1, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(3, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(4, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0)), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0)), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(4, 0, 0)), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of disconnected cables are equal"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(4, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkTwoDisconnectedByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(1, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(2, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(3, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.offset(1, 0, 0)).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS.offset(1, 0, 0)).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.offset(1, 0, 0)).getCenter(), Direction.NORTH, helper.absolutePos(POS.offset(1, 0, 0)), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0)), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0)), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0)), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of wrench-disconnected cables are equal"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkTwoDisconnectedByWrenchOffhand(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(1, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(2, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(3, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.OFF_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.offset(1, 0, 0)).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS.offset(1, 0, 0)).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.OFF_HAND, new BlockHitResult(helper.absolutePos(POS.offset(1, 0, 0)).getCenter(), Direction.NORTH, helper.absolutePos(POS.offset(1, 0, 0)), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0)), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0)), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0)), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of wrench-disconnected cables are equal"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkTwoDisconnectedAndReconnectedByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(1, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(2, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(3, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.offset(1, 0, 0)).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS.offset(1, 0, 0)).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.offset(1, 0, 0)).getCenter(), Direction.NORTH, helper.absolutePos(POS.offset(1, 0, 0)), false));
        player.setPos(helper.absolutePos(POS.offset(1, 0, 0)).getCenter().add(0.25, -1.5, 0.0));
        player.setYRot(90.0f);
        helper.getLevel().sendParticles((ParticleOptions)new ParticleBlurData(1.0f, 1.0f, 1.0f, 1.0f, 100.0f), player.position().x, player.position().y + (double)player.getEyeHeight(), player.position().z, 10, 0.0, 0.0, 0.0, 0.0);
        helper.getBlockState(POS.offset(1, 0, 0)).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.offset(1, 0, 0)).getCenter(), Direction.EAST, helper.absolutePos(POS.offset(1, 0, 0)), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0)), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0)), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0)), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of wrench-reconnected cables are equal"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST, Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST, Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkTwoRemoved(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(1, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(2, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(3, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.destroyBlock(POS.offset(1, 0, 0));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            Optional<INetwork> network2 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0)), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0)), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0)), null);
            helper.assertTrue(network1 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2.isEmpty(), (Component)Component.literal((String)"Network of removed cable is not empty"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0))), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityNotPresent((Item)RegistryEntries.ITEM_CABLE.get());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkTwoRemovedByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(1, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(2, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(3, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.offset(1, 0, 0)).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS.offset(1, 0, 0)).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.offset(1, 0, 0)).getCenter(), Direction.NORTH, helper.absolutePos(POS.offset(1, 0, 0)), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            Optional<INetwork> network2 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0)), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0)), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0)), null);
            helper.assertTrue(network1 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2.isEmpty(), (Component)Component.literal((String)"Network of removed cable is not empty"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0))), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent((Item)RegistryEntries.ITEM_CABLE.get());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkTwoRemovedByWrenchOffand(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(1, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(2, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.offset(3, 0, 0), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.OFF_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.offset(1, 0, 0)).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS.offset(1, 0, 0)).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.OFF_HAND, new BlockHitResult(helper.absolutePos(POS.offset(1, 0, 0)).getCenter(), Direction.NORTH, helper.absolutePos(POS.offset(1, 0, 0)), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            Optional<INetwork> network2 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0)), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0)), null);
            INetwork network4 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0)), null);
            helper.assertTrue(network1 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2.isEmpty(), (Component)Component.literal((String)"Network of removed cable is not empty"));
            helper.assertTrue(network3 == network4, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(1, 0, 0))), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(2, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.offset(3, 0, 0))), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent((Item)RegistryEntries.ITEM_CABLE.get());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkCableWithLever(GameTestHelper helper) {
        helper.setBlock(POS.offset(1, 0, 1), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)Items.LEVER);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.offset(1, 0, 1).south(), Direction.NORTH);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)player.getItemInHand(InteractionHand.MAIN_HAND).getItem(), (Object)Items.LEVER, (Component)Component.literal((String)"Item hand is incorrect"));
            helper.assertBlockNotPresent(Blocks.LEVER, POS.offset(1, 0, 1).north());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkVariableStoreSingle(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_VARIABLE_STORE.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkVariableStoreSingleAfterwards(GameTestHelper helper) {
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_VARIABLE_STORE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkVariableStoreDisconnectByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_VARIABLE_STORE.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.east()).getCenter().add(-0.25, -1.5, -0.5));
        helper.getBlockState(POS.east()).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.east()).getCenter(), Direction.NORTH, helper.absolutePos(POS.east()), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkVariableStoreBreakByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_VARIABLE_STORE.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.SOUTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_VARIABLE_STORE.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_VARIABLE_STORE.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkVariableStoreBreakByPickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_VARIABLE_STORE.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_VARIABLE_STORE.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkVariableStoreBreakByTnt(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_VARIABLE_STORE.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.above(), Blocks.TNT);
        helper.setBlock(POS.above().above(), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_VARIABLE_STORE.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_VARIABLE_STORE.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkCoalGeneratorSingle(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_COAL_GENERATOR.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkCoalGeneratorSingleAfterwards(GameTestHelper helper) {
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_COAL_GENERATOR.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkCoalGeneratorDisconnectByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_COAL_GENERATOR.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.east()).getCenter().add(-0.25, -1.5, -0.5));
        helper.getBlockState(POS.east()).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.east()).getCenter(), Direction.NORTH, helper.absolutePos(POS.east()), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkCoalGeneratorBreakByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_COAL_GENERATOR.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.SOUTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_VARIABLE_STORE.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_COAL_GENERATOR.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkCoalGeneratorBreakByPickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_COAL_GENERATOR.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_VARIABLE_STORE.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkCoalGeneratorBreakByTnt(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_COAL_GENERATOR.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.above(), Blocks.TNT);
        helper.setBlock(POS.above().above(), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_COAL_GENERATOR.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_COAL_GENERATOR.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkEnergyBatterySingle(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkEnergyBatterySingleAfterwards(GameTestHelper helper) {
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkEnergyBatteryDisconnectByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.east()).getCenter().add(-0.25, -1.5, -0.5));
        helper.getBlockState(POS.east()).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.east()).getCenter(), Direction.NORTH, helper.absolutePos(POS.east()), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkEnergyBatteryBreakByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).useItemOn(new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.SOUTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((BlockEnergyBattery)((Object)((Object)RegistryEntries.BLOCK_ENERGY_BATTERY.get()))).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkEnergyBatteryBreakByPickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_VARIABLE_STORE.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkEnergyBatteryBreakByTnt(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.above(), Blocks.TNT);
        helper.setBlock(POS.above().above(), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_VARIABLE_STORE.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((BlockEnergyBattery)((Object)((Object)RegistryEntries.BLOCK_ENERGY_BATTERY.get()))).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkDelayerSingle(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_DELAY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkDelayerSingleAfterwards(GameTestHelper helper) {
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_DELAY.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkDelayerDisconnectByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_DELAY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.east()).getCenter().add(-0.25, -1.5, -0.5));
        helper.getBlockState(POS.east()).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.east()).getCenter(), Direction.NORTH, helper.absolutePos(POS.east()), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkDelayerBreakByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_DELAY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.SOUTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_DELAY.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_DELAY.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkDelayerBreakByPickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_DELAY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_DELAY.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkDelayerBreakByTnt(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_DELAY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.above(), Blocks.TNT);
        helper.setBlock(POS.above().above(), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_VARIABLE_STORE.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_DELAY.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkMaterializerSingle(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_MATERIALIZER.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkMaterializerSingleAfterwards(GameTestHelper helper) {
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_MATERIALIZER.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkMaterializerDisconnectByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_MATERIALIZER.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.east()).getCenter().add(-0.25, -1.5, -0.5));
        helper.getBlockState(POS.east()).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.east()).getCenter(), Direction.NORTH, helper.absolutePos(POS.east()), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkMaterializerBreakByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_MATERIALIZER.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.SOUTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_MATERIALIZER.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_MATERIALIZER.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkMaterializerBreakByPickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_MATERIALIZER.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_MATERIALIZER.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkMaterializerBreakByTnt(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_MATERIALIZER.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.above(), Blocks.TNT);
        helper.setBlock(POS.above().above(), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_MATERIALIZER.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_MATERIALIZER.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkProxySingle(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_PROXY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkProxySingleAfterwards(GameTestHelper helper) {
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_PROXY.value());
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 == network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST, Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkProxyDisconnectByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_PROXY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.setPos(helper.absolutePos(POS.east()).getCenter().add(-0.25, -1.5, -0.5));
        helper.getBlockState(POS.east()).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS.east()).getCenter(), Direction.NORTH, helper.absolutePos(POS.east()), false));
        helper.succeedWhen(() -> {
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1 == network2, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.SOUTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.NORTH}), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkProxyBreakByWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_PROXY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.SOUTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_PROXY.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_PROXY.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkProxyBreakByPickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_PROXY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter());
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_PROXY.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            INetwork network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south()), null);
            INetwork network3 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.east()), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertTrue(network2 != network3, (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.east())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkProxyBreakByTnt(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_PROXY.value());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.above(), Blocks.TNT);
        helper.setBlock(POS.above().above(), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_PROXY.value(), POS);
            Optional<INetwork> network1 = NetworkHelpers.getNetwork((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1.isEmpty(), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertItemEntityPresent(((Block)RegistryEntries.BLOCK_PROXY.get()).asItem());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkMonodirectional(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.south().south().south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.CONNECTOR_MONO, new ItemStack((ItemLike)PartTypes.CONNECTOR_MONO.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.south().south().south()), Direction.NORTH, (IPartType)PartTypes.CONNECTOR_MONO, new ItemStack((ItemLike)PartTypes.CONNECTOR_MONO.getItem()));
        helper.succeedWhen(() -> {
            INetwork network2;
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1 == (network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south().south().south()), null)), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south().south().south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkMonodirectionalUnconnected(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.south().south().south().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.CONNECTOR_MONO, new ItemStack((ItemLike)PartTypes.CONNECTOR_MONO.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.south().south().south().east()), Direction.NORTH, (IPartType)PartTypes.CONNECTOR_MONO, new ItemStack((ItemLike)PartTypes.CONNECTOR_MONO.getItem()));
        helper.succeedWhen(() -> {
            INetwork network2;
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertFalse(network1 == (network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south().south().south().east()), null)), (Component)Component.literal((String)"Networks of connected cables are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south().south().south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkOmnidirectional(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.south().south().south().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        ItemStack omniDirectionalConnector = new ItemStack((ItemLike)PartTypes.CONNECTOR_OMNI.getItem());
        omniDirectionalConnector.set(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP, (Object)1);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.CONNECTOR_OMNI, omniDirectionalConnector.copy());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.south().south().south().east()), Direction.NORTH, (IPartType)PartTypes.CONNECTOR_OMNI, omniDirectionalConnector.copy());
        helper.succeedWhen(() -> {
            INetwork network2;
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1 == (network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south().south().south().east()), null)), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south().south().south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testNetworkOmnidirectionalUnconnected(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.south().south().south().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        ItemStack omniDirectionalConnector1 = new ItemStack((ItemLike)PartTypes.CONNECTOR_OMNI.getItem());
        omniDirectionalConnector1.set(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP, (Object)1);
        ItemStack omniDirectionalConnector2 = new ItemStack((ItemLike)PartTypes.CONNECTOR_OMNI.getItem());
        omniDirectionalConnector2.set(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP, (Object)2);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.CONNECTOR_OMNI, omniDirectionalConnector1.copy());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.south().south().south().east()), Direction.NORTH, (IPartType)PartTypes.CONNECTOR_OMNI, omniDirectionalConnector2.copy());
        helper.succeedWhen(() -> {
            INetwork network2;
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertFalse(network1 == (network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.south().south().south().east()), null)), (Component)Component.literal((String)"Networks of connected cables are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.south().south().south())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }
}

