/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import com.google.common.collect.Sets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPathElement;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.core.part.read.PartStateReaderBase;

public class GameTestsParts {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(1, 1, 1);

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderOnCable(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder != null, (Component)Component.literal((String)"Placed part is missing"));
            helper.assertTrue(partStateHolder.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
            helper.assertTrue(partStateHolder.getState().isEnabled(), (Component)Component.literal((String)"Placed part is not enabled"));
            helper.assertTrue(partStateHolder.getState().getChannel() == 0, (Component)Component.literal((String)"Placed part is not on channel 0"));
            helper.assertTrue(CableHelpers.isNoFakeCable((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null), (Component)Component.literal((String)"Cable is fake"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderOnCableAsPlayer(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.south(), Direction.NORTH);
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder != null, (Component)Component.literal((String)"Placed part is missing"));
            helper.assertTrue(partStateHolder.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
            helper.assertTrue(partStateHolder.getState().isEnabled(), (Component)Component.literal((String)"Placed part is not enabled"));
            helper.assertTrue(partStateHolder.getState().getChannel() == 0, (Component)Component.literal((String)"Placed part is not on channel 0"));
            helper.assertTrue(CableHelpers.isNoFakeCable((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null), (Component)Component.literal((String)"Cable is fake"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithoutCableAsPlayer(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.south(), Direction.NORTH);
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.SOUTH));
            helper.assertTrue(partStateHolder != null, (Component)Component.literal((String)"Placed part is missing"));
            helper.assertTrue(partStateHolder.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
            helper.assertTrue(partStateHolder.getState().isEnabled(), (Component)Component.literal((String)"Placed part is not enabled"));
            helper.assertTrue(partStateHolder.getState().getChannel() == 0, (Component)Component.literal((String)"Placed part is not on channel 0"));
            helper.assertTrue(!CableHelpers.isNoFakeCable((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.north()), null), (Component)Component.literal((String)"Cable is not fake"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderOnCableRemove(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        helper.destroyBlock(POS);
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder == null, (Component)Component.literal((String)"Part was not removed"));
            helper.assertItemEntityNotPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertItemEntityNotPresent((Item)RegistryEntries.ITEM_CABLE.get());
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithoutCableRemove(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.north().north(), Direction.SOUTH);
        helper.destroyBlock(POS);
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder == null, (Component)Component.literal((String)"Part was not removed"));
            helper.assertItemEntityNotPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertItemEntityNotPresent((Item)RegistryEntries.ITEM_CABLE.get());
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderOnCableRemoveWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.NORTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder == null, (Component)Component.literal((String)"Part was not removed"));
            helper.assertItemEntityPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertTrue(((ItemEntity)helper.getEntities(EntityType.ITEM).get(0)).getItem().has(RegistryEntries.DATACOMPONENT_PART_STATE), (Component)Component.literal((String)"Dropped part must have a state"));
            helper.assertItemEntityNotPresent((Item)RegistryEntries.ITEM_CABLE.get());
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithoutCableRemoveWrench(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.north().north(), Direction.SOUTH);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.NORTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder == null, (Component)Component.literal((String)"Part was not removed"));
            helper.assertItemEntityPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertTrue(((ItemEntity)helper.getEntities(EntityType.ITEM).get(0)).getItem().has(RegistryEntries.DATACOMPONENT_PART_STATE), (Component)Component.literal((String)"Dropped part must have a state"));
            helper.assertItemEntityNotPresent((Item)RegistryEntries.ITEM_CABLE.get());
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderOnCableRemovePickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder == null, (Component)Component.literal((String)"Part was not removed"));
            helper.assertItemEntityPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertTrue(!((ItemEntity)helper.getEntities(EntityType.ITEM).get(0)).getItem().has(RegistryEntries.DATACOMPONENT_PART_STATE), (Component)Component.literal((String)"Dropped part must not have a state"));
            helper.assertItemEntityNotPresent((Item)RegistryEntries.ITEM_CABLE.get());
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithoutCableRemovePickaxe(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.north().north(), Direction.SOUTH);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter().add(0.25, -1.5, -0.5));
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder == null, (Component)Component.literal((String)"Part was not removed"));
            helper.assertItemEntityPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertTrue(!((ItemEntity)helper.getEntities(EntityType.ITEM).get(0)).getItem().has(RegistryEntries.DATACOMPONENT_PART_STATE), (Component)Component.literal((String)"Dropped part must not have a state"));
            helper.assertItemEntityNotPresent((Item)RegistryEntries.ITEM_CABLE.get());
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithoutCableRemoveTnt(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.north().north(), Direction.SOUTH);
        helper.setBlock(POS.above(), Blocks.TNT);
        helper.setBlock(POS.above().above(), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder == null, (Component)Component.literal((String)"Placed part is not missing"));
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderOnCableRemoveCableWrench(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RegistryEntries.ITEM_WRENCH.value()));
        player.setPos(helper.absolutePos(POS).getCenter().add(0.0, -1.5, 0.5));
        player.setYRot(180.0f);
        helper.getBlockState(POS).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.SOUTH, helper.absolutePos(POS), false));
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder != null, (Component)Component.literal((String)"Placed part is missing"));
            helper.assertTrue(partStateHolder.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
            helper.assertTrue(partStateHolder.getState().isEnabled(), (Component)Component.literal((String)"Placed part is not enabled"));
            helper.assertTrue(partStateHolder.getState().getChannel() == 0, (Component)Component.literal((String)"Placed part is not on channel 0"));
            helper.assertTrue(!CableHelpers.isNoFakeCable((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null), (Component)Component.literal((String)"Cable is not fake"));
            helper.assertItemEntityNotPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertItemEntityPresent((Item)RegistryEntries.ITEM_CABLE.get());
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderOnCableRemoveCableWithPickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        player.setPos(helper.absolutePos(POS).getCenter().add(0.0, -1.5, 0.5));
        player.setYRot(180.0f);
        helper.getBlockState(POS).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS)));
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder != null, (Component)Component.literal((String)"Placed part is missing"));
            helper.assertTrue(partStateHolder.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
            helper.assertTrue(partStateHolder.getState().isEnabled(), (Component)Component.literal((String)"Placed part is not enabled"));
            helper.assertTrue(partStateHolder.getState().getChannel() == 0, (Component)Component.literal((String)"Placed part is not on channel 0"));
            helper.assertTrue(!CableHelpers.isNoFakeCable((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null), (Component)Component.literal((String)"Cable is not fake"));
            helper.assertItemEntityNotPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertItemEntityPresent((Item)RegistryEntries.ITEM_CABLE.get());
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderOnCableRemoveTnt(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        helper.setBlock(POS.above(), Blocks.TNT);
        helper.setBlock(POS.above().above(), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
            helper.assertTrue(partStateHolder == null, (Component)Component.literal((String)"Placed part is not missing"));
            helper.assertItemEntityPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertTrue(!((ItemEntity)helper.getEntities(EntityType.ITEM).get(0)).getItem().has(RegistryEntries.DATACOMPONENT_PART_STATE), (Component)Component.literal((String)"Dropped part must not have a state"));
            helper.assertBlockNotPresent((Block)RegistryEntries.BLOCK_CABLE.value(), POS);
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithStateOnCable(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        IPartState state = PartTypes.REDSTONE_READER.constructDefaultState();
        ((PartStateBase)state).generateId();
        ItemStack partStack = PartTypes.REDSTONE_READER.getItemStack(ValueDeseralizationContext.of((Level)helper.getLevel()), new PartPathElement(POS), state, true);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, partStack);
        helper.succeedWhen(() -> GameTestsParts.lambda$testPartsRedstoneReaderWithStateOnCable$13(helper, (PartStateReaderBase)state));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithStateOnCableAsPlayer(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        IPartState state = PartTypes.REDSTONE_READER.constructDefaultState();
        ((PartStateBase)state).generateId();
        ItemStack partStack = PartTypes.REDSTONE_READER.getItemStack(ValueDeseralizationContext.of((Level)helper.getLevel()), new PartPathElement(POS), state, true);
        player.setItemInHand(InteractionHand.MAIN_HAND, partStack);
        helper.placeAt(player, partStack, POS.south(), Direction.NORTH);
        helper.succeedWhen(() -> GameTestsParts.lambda$testPartsRedstoneReaderWithStateOnCableAsPlayer$14(helper, (PartStateReaderBase)state));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsBlocksCableConnection(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.succeedWhen(() -> {
            INetwork network2;
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS), null);
            helper.assertTrue(network1 != (network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.north()), null)), (Component)Component.literal((String)"Networks of cables with part inbetween are equal"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS)), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.north())), (Object)Sets.newHashSet(), (Component)Component.literal((String)"Connected cables are invalid"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithLever(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)Items.LEVER);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.south(), Direction.NORTH);
        helper.succeedWhen(() -> {
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty(), (Component)Component.literal((String)"Item hand is not empty"));
            helper.assertBlockPresent(Blocks.LEVER, POS.north());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithoutCableAsPlayerAddCable(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.south(), Direction.NORTH);
        ItemStack itemStackCable = new ItemStack(RegistryEntries.ITEM_CABLE);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackCable);
        helper.placeAt(player, itemStackCable, POS.south(), Direction.NORTH);
        helper.succeedWhen(() -> {
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.SOUTH));
            helper.assertTrue(partStateHolder != null, (Component)Component.literal((String)"Placed part is missing"));
            helper.assertTrue(partStateHolder.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
            helper.assertTrue(partStateHolder.getState().isEnabled(), (Component)Component.literal((String)"Placed part is not enabled"));
            helper.assertTrue(partStateHolder.getState().getChannel() == 0, (Component)Component.literal((String)"Placed part is not on channel 0"));
            helper.assertTrue(CableHelpers.isNoFakeCable((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.north()), null), (Component)Component.literal((String)"Cable is fake"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testPartsRedstoneReaderWithoutCableAsPlayerAddCableTwo(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack.copy());
        helper.placeAt(player, itemStack.copy(), POS.south(), Direction.NORTH);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack.copy());
        helper.placeAt(player, itemStack.copy(), POS.south().east(), Direction.NORTH);
        ItemStack itemStackCable = new ItemStack(RegistryEntries.ITEM_CABLE);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackCable.copy());
        helper.placeAt(player, itemStackCable.copy(), POS.south(), Direction.NORTH);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackCable.copy());
        helper.placeAt(player, itemStackCable.copy(), POS.south().east(), Direction.NORTH);
        helper.succeedWhen(() -> {
            INetwork network2;
            INetwork network1 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.north()), null);
            helper.assertTrue(network1 == (network2 = NetworkHelpers.getNetworkChecked((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.north().east()), null)), (Component)Component.literal((String)"Networks of connected cables are not equal"));
            PartHelpers.PartStateHolder<?, ?> partStateHolder1 = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.SOUTH));
            helper.assertTrue(partStateHolder1 != null, (Component)Component.literal((String)"Placed part is missing"));
            helper.assertTrue(partStateHolder1.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
            helper.assertTrue(partStateHolder1.getState().isEnabled(), (Component)Component.literal((String)"Placed part is not enabled"));
            helper.assertTrue(partStateHolder1.getState().getChannel() == 0, (Component)Component.literal((String)"Placed part is not on channel 0"));
            helper.assertTrue(CableHelpers.isNoFakeCable((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.north()), null), (Component)Component.literal((String)"Cable is fake"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.north())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.EAST}), (Component)Component.literal((String)"Connected cables are invalid"));
            PartHelpers.PartStateHolder<?, ?> partStateHolder2 = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.north().east()), Direction.SOUTH));
            helper.assertTrue(partStateHolder2 != null, (Component)Component.literal((String)"Placed part 2 is missing"));
            helper.assertTrue(partStateHolder2.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part 2 is incorrect"));
            helper.assertTrue(partStateHolder2.getState().isEnabled(), (Component)Component.literal((String)"Placed part 2 is not enabled"));
            helper.assertTrue(partStateHolder2.getState().getChannel() == 0, (Component)Component.literal((String)"Placed part 2 is not on channel 0"));
            helper.assertTrue(CableHelpers.isNoFakeCable((ILevelExtension)helper.getLevel(), helper.absolutePos(POS.north().east()), null), (Component)Component.literal((String)"Cable 2 is fake"));
            helper.assertValueEqual(CableHelpers.getExternallyConnectedCables((Level)helper.getLevel(), helper.absolutePos(POS.north().east())), (Object)Sets.newHashSet((Object[])new Direction[]{Direction.WEST}), (Component)Component.literal((String)"Connected cables 2 are invalid"));
        });
    }

    private static /* synthetic */ void lambda$testPartsRedstoneReaderWithStateOnCableAsPlayer$14(GameTestHelper helper, PartStateReaderBase state) {
        PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
        helper.assertTrue(partStateHolder != null, (Component)Component.literal((String)"Placed part is missing"));
        helper.assertTrue(partStateHolder.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
        helper.assertValueEqual((Object)partStateHolder.getState().getId(), (Object)state.getId(), (Component)Component.literal((String)"Part id is incorrect"));
    }

    private static /* synthetic */ void lambda$testPartsRedstoneReaderWithStateOnCable$13(GameTestHelper helper, PartStateReaderBase state) {
        PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.NORTH));
        helper.assertTrue(partStateHolder != null, (Component)Component.literal((String)"Placed part is missing"));
        helper.assertTrue(partStateHolder.getPart() == PartTypes.REDSTONE_READER, (Component)Component.literal((String)"Placed part is incorrect"));
        helper.assertValueEqual((Object)partStateHolder.getState().getId(), (Object)state.getId(), (Component)Component.literal((String)"Part id is incorrect"));
    }
}

