/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest.integration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integrateddynamics.gametest.integration.Asserts;
import org.cyclops.integrateddynamics.gametest.integration.DummyValueType;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariable;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableIngredients;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableRecipe;

public class TestRecipeOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariableRecipe rMain;
    private DummyVariableIngredients iMainOut;
    private DummyVariableIngredients iItems;

    @IntegrationBefore
    public void before() {
        ArrayList ingredientsIn = Lists.newArrayList();
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.OAK_BOAT), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Blocks.STONE), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)13)));
        IdentityHashMap ingredientsOut = Maps.newIdentityHashMap();
        ingredientsOut.put(IngredientComponent.ENERGY, Lists.newArrayList((Object[])new Long[]{777L}));
        ingredientsOut.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{new FluidStack((Fluid)Fluids.WATER, 123)}));
        ingredientsOut.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.OAK_BOAT), new ItemStack((ItemLike)Item.byBlock((Block)Blocks.STONE))}));
        this.iMainOut = new DummyVariableIngredients(ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)new MixedIngredients((Map)ingredientsOut)));
        this.rMain = new DummyVariableRecipe(ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)RecipeDefinition.ofIngredients((IngredientComponent)IngredientComponent.ITEMSTACK, (List)ingredientsIn, (IMixedIngredients)((IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)this.iMainOut.getValue()).getRawValue().get()))));
        this.iItems = new DummyVariableIngredients(ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstances((IngredientComponent)IngredientComponent.ITEMSTACK, (Collection)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), new ItemStack((ItemLike)Blocks.OAK_DOOR), ItemStack.EMPTY}))));
    }

    @IntegrationTest
    public void testInput() throws EvaluationException {
        IValue res1 = Operators.RECIPE_INPUT.evaluate(this.rMain);
        Asserts.check(res1 instanceof ValueObjectTypeIngredients.ValueIngredients, "result is an ingredients");
        TestHelpers.assertEqual(res1, ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.fromRecipeInput((IRecipeDefinition)((IRecipeDefinition)((ValueObjectTypeRecipe.ValueRecipe)this.rMain.getValue()).getRawValue().get()))), "input is correct");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInputSizeLarge() throws EvaluationException {
        Operators.RECIPE_INPUT.evaluate(this.rMain, this.rMain);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInputSizeSmall() throws EvaluationException {
        Operators.RECIPE_INPUT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInputSize() throws EvaluationException {
        Operators.RECIPE_INPUT.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testOutput() throws EvaluationException {
        IValue res1 = Operators.RECIPE_OUTPUT.evaluate(this.rMain);
        Asserts.check(res1 instanceof ValueObjectTypeIngredients.ValueIngredients, "result is an ingredients");
        TestHelpers.assertEqual(res1, this.iMainOut.getValue(), "output is correct");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testOutputSizeLarge() throws EvaluationException {
        Operators.RECIPE_OUTPUT.evaluate(this.rMain, this.rMain);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testOutputSizeSmall() throws EvaluationException {
        Operators.RECIPE_OUTPUT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testOutputSize() throws EvaluationException {
        Operators.RECIPE_OUTPUT.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testWithInput() throws EvaluationException {
        IValue res1 = Operators.RECIPE_WITH_INPUT.evaluate(this.rMain, this.iItems);
        Asserts.check(res1 instanceof ValueObjectTypeRecipe.ValueRecipe, "result is a recipe");
        ArrayList ingredientsIn = Lists.newArrayList();
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Blocks.OAK_DOOR), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)13)));
        RecipeDefinition recipe = RecipeDefinition.ofIngredients((IngredientComponent)IngredientComponent.ITEMSTACK, (List)ingredientsIn, (IMixedIngredients)((IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)this.iMainOut.getValue()).getRawValue().get()));
        TestHelpers.assertEqual(res1, ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)recipe), "input is correct");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithInputSizeLarge() throws EvaluationException {
        Operators.RECIPE_WITH_INPUT.evaluate(this.rMain, this.iItems, this.rMain);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithInputSizeSmall() throws EvaluationException {
        Operators.RECIPE_WITH_INPUT.evaluate(this.rMain);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithInputSize() throws EvaluationException {
        Operators.RECIPE_WITH_INPUT.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testWithOutput() throws EvaluationException {
        IValue res1 = Operators.RECIPE_WITH_OUTPUT.evaluate(this.rMain, this.iItems);
        Asserts.check(res1 instanceof ValueObjectTypeRecipe.ValueRecipe, "result is a recipe");
        ArrayList ingredientsIn = Lists.newArrayList();
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.OAK_BOAT), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Blocks.STONE), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)13)));
        RecipeDefinition recipe = RecipeDefinition.ofIngredients((IngredientComponent)IngredientComponent.ITEMSTACK, (List)ingredientsIn, (IMixedIngredients)((IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)this.iItems.getValue()).getRawValue().get()));
        TestHelpers.assertEqual(res1, ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)recipe), "output is correct");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithOutputSizeLarge() throws EvaluationException {
        Operators.RECIPE_WITH_OUTPUT.evaluate(this.rMain, this.iItems, this.rMain);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithOutputSizeSmall() throws EvaluationException {
        Operators.RECIPE_WITH_OUTPUT.evaluate(this.rMain);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithOutputSize() throws EvaluationException {
        Operators.RECIPE_WITH_OUTPUT.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testWithInputOutput() throws EvaluationException {
        IValue res1 = Operators.RECIPE_WITH_INPUT_OUTPUT.evaluate(this.iItems, this.iMainOut);
        Asserts.check(res1 instanceof ValueObjectTypeRecipe.ValueRecipe, "result is a recipe");
        ArrayList ingredientsIn = Lists.newArrayList();
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Blocks.OAK_DOOR), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)13)));
        RecipeDefinition recipe = RecipeDefinition.ofIngredients((IngredientComponent)IngredientComponent.ITEMSTACK, (List)ingredientsIn, (IMixedIngredients)((IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)this.iMainOut.getValue()).getRawValue().get()));
        TestHelpers.assertEqual(res1, ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)recipe), "input is correct");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithInputOutputSizeLarge() throws EvaluationException {
        Operators.RECIPE_WITH_INPUT_OUTPUT.evaluate(this.iItems, this.iMainOut, this.rMain);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithInputOutputSizeSmall() throws EvaluationException {
        Operators.RECIPE_WITH_INPUT_OUTPUT.evaluate(this.iItems);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithInputOutputSize() throws EvaluationException {
        Operators.RECIPE_WITH_INPUT_OUTPUT.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }
}

