/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.dryingbasin;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;
import org.cyclops.integrateddynamicscompat.modcompat.common.JeiReiHelpers;

public class DryingBasinRecipeCategory
implements IRecipeCategory<RecipeHolder<RecipeDryingBasin>> {
    public static final IRecipeHolderType<RecipeDryingBasin> TYPE = IRecipeHolderType.create((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_DRYING_BASIN.get()));
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public DryingBasinRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"integrateddynamicscompat", (String)"textures/gui/drying_basin_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 93, 53);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_DRYING_BASIN.get()));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 94, 0, 11, 28);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public IRecipeType<RecipeHolder<RecipeDryingBasin>> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)((BlockDryingBasin)((Object)RegistryEntries.BLOCK_DRYING_BASIN.get())).getDescriptionId());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<RecipeDryingBasin> recipeHolder, IFocusGroup focuses) {
        RecipeDryingBasin recipe = (RecipeDryingBasin)recipeHolder.value();
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 2, 8);
        recipe.getInputIngredient().ifPresent(arg_0 -> ((IRecipeSlotBuilder)inputSlot).add(arg_0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 8).add(recipe.getOutputItemFirst().orElse(ItemStack.EMPTY));
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 28).setFluidRenderer(1000L, true, 8, 9).add((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getInputFluid().orElse(FluidStack.EMPTY));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 28).setFluidRenderer(1000L, true, 8, 9).add((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid().orElse(FluidStack.EMPTY));
    }

    public void draw(RecipeHolder<RecipeDryingBasin> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 43, 11);
        Font fontRenderer = Minecraft.getInstance().font;
        MutableComponent duration = JeiReiHelpers.getDurationSecondsTextComponent(((RecipeDryingBasin)recipeHolder.value()).getDuration());
        guiGraphics.drawString(fontRenderer, (Component)duration, (this.background.getWidth() - fontRenderer.width((FormattedText)duration)) / 2 + 3, 42, ARGB.opaque((int)-8355712), false);
    }
}

