/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.rei.dryingbasin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.compress.utils.Lists;
import org.cyclops.integrateddynamics.core.recipe.display.RecipeDisplayDryingBasin;
import org.cyclops.integrateddynamicscompat.modcompat.rei.dryingbasin.ReiDryingBasinCategory;
import org.jetbrains.annotations.Nullable;

public class ReiDryingBasinRecipe
implements Display {
    public static final DisplaySerializer<ReiDryingBasinRecipe> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecipeDisplayDryingBasin.MAP_CODEC.fieldOf("display").forGetter(ReiDryingBasinRecipe::getRecipeDisplay), (App)Codec.INT.xmap(RecipeDisplayId::new, RecipeDisplayId::index).optionalFieldOf("id").forGetter(ReiDryingBasinRecipe::recipeDisplayId)).apply((Applicative)instance, ReiDryingBasinRecipe::new)), (StreamCodec)StreamCodec.composite(RecipeDisplayDryingBasin.STREAM_CODEC, ReiDryingBasinRecipe::getRecipeDisplay, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT.map(RecipeDisplayId::new, RecipeDisplayId::index)), ReiDryingBasinRecipe::recipeDisplayId, ReiDryingBasinRecipe::new), (boolean)false);
    private final RecipeDisplayDryingBasin recipeDisplay;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;
    private final int duration;
    private final Optional<RecipeDisplayId> id;

    public ReiDryingBasinRecipe(RecipeDisplayDryingBasin recipeDisplay, Optional<RecipeDisplayId> id) {
        this.recipeDisplay = recipeDisplay;
        this.inputs = Lists.newArrayList();
        this.outputs = Lists.newArrayList();
        this.duration = recipeDisplay.duration();
        this.id = id;
        this.inputs.add(EntryIngredients.ofSlotDisplay((SlotDisplay)recipeDisplay.inputIngredient()));
        this.inputs.add(EntryIngredients.of((Fluid)recipeDisplay.inputFluid().getFluid(), (long)recipeDisplay.inputFluid().getAmount()));
        this.outputs.add(EntryIngredients.ofSlotDisplay((SlotDisplay)recipeDisplay.outputItem()));
        this.outputs.add(EntryIngredients.of((Fluid)recipeDisplay.outputFluid().getFluid(), (long)recipeDisplay.outputFluid().getAmount()));
    }

    public RecipeDisplayDryingBasin getRecipeDisplay() {
        return this.recipeDisplay;
    }

    public int getDuration() {
        return this.duration;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiDryingBasinCategory.ID;
    }

    public Optional<RecipeDisplayId> recipeDisplayId() {
        return this.id;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.empty();
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

