/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.part;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.client.render.part.IPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.joml.Quaternionfc;

public abstract class PartOverlayRendererBase
implements IPartOverlayRenderer {
    protected int getMaxRenderDistance() {
        return (int)Math.pow(GeneralConfig.partOverlayRenderdistance, 2.0);
    }

    protected boolean shouldRender(BlockPos pos) {
        if (!NetworkHelpers.shouldWork()) {
            return false;
        }
        LocalPlayer renderEntity = Minecraft.getInstance().player;
        return renderEntity.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < (double)this.getMaxRenderDistance();
    }

    protected void setMatrixOrientation(PoseStack matrixStack, Direction direction) {
        int rotationY = 0;
        int rotationX = 0;
        if (direction == Direction.SOUTH) {
            rotationY = 0;
        } else if (direction == Direction.NORTH) {
            rotationY = 180;
        } else if (direction == Direction.EAST) {
            rotationY = 90;
        } else if (direction == Direction.WEST) {
            rotationY = -90;
        } else if (direction == Direction.UP) {
            rotationX = -90;
        } else if (direction == Direction.DOWN) {
            rotationX = 90;
        }
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)rotationY));
        matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)rotationX));
    }
}

