/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyMaterialized;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyMaterializedFactory
implements IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<IValueType<IValue>, IValue, ValueTypeListProxyMaterialized<IValueType<IValue>, IValue>> {
    @Override
    public ResourceLocation getName() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"materialized");
    }

    @Override
    public void serialize(ValueOutput valueOutput, ValueTypeListProxyMaterialized<IValueType<IValue>, IValue> values) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        ValueOutput.ValueOutputList list = valueOutput.childrenList("values");
        Object valueType = values.getValueType();
        boolean heterogeneous = false;
        try {
            if (valueType.isCategory() && values.getLength() > 0) {
                heterogeneous = true;
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        valueOutput.putString("valueType", valueType.getUniqueName().toString());
        for (IValue value : values) {
            ValueOutput valueTag = list.addChild();
            if (heterogeneous) {
                valueTag.putString("valueType", value.getType().getUniqueName().toString());
            }
            ValueHelpers.serializeRaw(valueTag, value);
        }
    }

    @Override
    public ValueTypeListProxyMaterialized<IValueType<IValue>, IValue> deserialize(ValueInput valueInput) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        String valueTypeName = (String)valueInput.getString("valueType").orElseThrow();
        IValueType valueType = ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)valueTypeName));
        if (valueType == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized materialized list proxy value because the value type by name '%s' was not found.", valueTypeName));
        }
        boolean heterogeneous = valueType.isCategory();
        IValueType elementValueType = valueType;
        ImmutableList.Builder builder = ImmutableList.builder();
        ValueInput.ValueInputList list = (ValueInput.ValueInputList)valueInput.childrenList("values").orElseThrow();
        for (ValueInput valueTag : list) {
            String subValueTypeName;
            if (heterogeneous && (elementValueType = ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)(subValueTypeName = (String)valueTag.getString("valueType").orElseThrow())))) == null) {
                throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized materialized list proxy value because the value type by name '%s' was not found.", subValueTypeName));
            }
            Object deserializedValue = ValueHelpers.deserializeRaw(valueTag, elementValueType);
            builder.add(deserializedValue);
        }
        return new ValueTypeListProxyMaterialized<IValueType<IValue>, IValue>(valueType, (List<IValue>)builder.build());
    }
}

