/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsReadRedstone {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadRedstoneBooleanLow(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.REDSTONE_BLOCK);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.REDSTONE_READER, Aspects.Read.Redstone.BOOLEAN_LOW, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadRedstoneBooleanNonLow(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.REDSTONE_BLOCK);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.REDSTONE_READER, Aspects.Read.Redstone.BOOLEAN_NONLOW, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadRedstoneBooleanHigh(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.REDSTONE_BLOCK);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.REDSTONE_READER, Aspects.Read.Redstone.BOOLEAN_HIGH, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadRedstoneBooleanClock(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.REDSTONE_BLOCK);
        Supplier<IAspectVariable> variableSupplier = GameTestHelpersIntegratedDynamics.testReadAspectSetup(POS, helper, PartTypes.REDSTONE_READER, Aspects.Read.Redstone.BOOLEAN_CLOCK);
        helper.startSequence().thenWaitUntil(() -> GameTestHelpersIntegratedDynamics.assertValueEqual(helper, (IVariable)variableSupplier.get(), (IValue)ValueTypeBoolean.ValueBoolean.of(false))).thenWaitUntil(() -> GameTestHelpersIntegratedDynamics.assertValueEqual(helper, (IVariable)variableSupplier.get(), (IValue)ValueTypeBoolean.ValueBoolean.of(true))).thenSucceed();
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadRedstoneInteger(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chest.setItem(0, new ItemStack((ItemLike)Items.COAL));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.REDSTONE_READER, Aspects.Read.Redstone.INTEGER_COMPARATOR, ValueTypeInteger.ValueInteger.of(1));
    }
}

