/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import com.google.common.collect.Lists;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.blockentity.BlockEntityVariablestore;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.PartTypePanelDisplay;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsCombinedAspects {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderToWriter(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), Aspects.Write.Redstone.INTEGER, variableAspect);
        helper.setBlock(POS.east().east().below(), Blocks.STONE);
        helper.setBlock(POS.east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertBlockProperty(POS.east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(14));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Writer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.REDSTONE_WRITER.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), Aspects.Write.Redstone.INTEGER, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(Aspects.Write.Redstone.INTEGER).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsNothingToWriter(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        helper.setBlock(POS.east().east().below(), Blocks.STONE);
        helper.setBlock(POS.east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertBlockProperty(POS.east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Writer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.REDSTONE_WRITER.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.INACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertTrue(partStateWriter.getActiveAspect() == null, (Component)Component.literal((String)"Active aspect is incorrect"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderToWriterDisconnected(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST), Aspects.Write.Redstone.INTEGER, variableAspect);
        helper.setBlock(POS.east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.east().east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.east().east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.east().east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertBlockProperty(POS.east().east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.east().east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST)).getState();
            Object partStateReader = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST)).getState();
            helper.assertTrue(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Writer is not deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.REDSTONE_WRITER.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ERROR, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), Aspects.Write.Redstone.INTEGER, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertValueEqual(partStateWriter.getErrors(Aspects.Write.Redstone.INTEGER), (Object)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"variable.integrateddynamics.error.part_not_in_network", (Object[])new Object[]{Integer.toString(partStateReader.getId())})}), (Component)Component.literal((String)"Active aspect errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderToDisplay(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), variableAspect);
        helper.succeedWhen(() -> {
            helper.assertFalse(((PartTypePanelDisplay.State)partAndState.getRight()).isDeactivated(), (Component)Component.literal((String)"Display panel is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.DISPLAY_PANEL.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertTrue(((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors().isEmpty(), (Component)Component.literal((String)"Display panel has errors"));
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeInteger.ValueInteger.of(14));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsNothingToDisplay(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.succeedWhen(() -> {
            PartTypePanelDisplay.State partState = (PartTypePanelDisplay.State)PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST)).getState();
            helper.assertFalse(partState.isDeactivated(), (Component)Component.literal((String)"Display panel is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.DISPLAY_PANEL.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.INACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, partState.getDisplayValue(), null);
            helper.assertValueEqual(partState.getGlobalErrors(), (Object)Lists.newArrayList(), (Component)Component.literal((String)"Display panel errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsBlankVariableToDisplay(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST), new ItemStack(RegistryEntries.ITEM_VARIABLE));
        helper.succeedWhen(() -> {
            helper.assertFalse(((PartTypePanelDisplay.State)partAndState.getRight()).isDeactivated(), (Component)Component.literal((String)"Display panel is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.DISPLAY_PANEL.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeBoolean.ValueBoolean.of(true));
            helper.assertValueEqual(((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors(), (Object)Lists.newArrayList(), (Component)Component.literal((String)"Display panel errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderAddOperatorToDisplay(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north(), BlockEntityVariablestore.class);
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        helper.setBlock(POS.south(), Blocks.REDSTONE_BLOCK);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        ItemStack variableAspect2 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH), Aspects.Read.Redstone.INTEGER_VALUE);
        variableStore.getInventory().setItem(0, variableAspect1);
        variableStore.getInventory().setItem(1, variableAspect2);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.ARITHMETIC_ADDITION, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), variableAdded);
        helper.succeedWhen(() -> GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeInteger.ValueInteger.of(29)));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsDisplayPanelAsVariableStore(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.NORTH, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        helper.setBlock(POS.south(), Blocks.REDSTONE_BLOCK);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        ItemStack variableAspect2 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.NORTH), variableAspect1);
        GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.EAST), variableAspect2);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.ARITHMETIC_ADDITION, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), variableAdded);
        helper.succeedWhen(() -> GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeInteger.ValueInteger.of(29)));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderAddOperatorToDisplayIncompleteVariableStore(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north(), BlockEntityVariablestore.class);
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        helper.setBlock(POS.south(), Blocks.REDSTONE_BLOCK);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        ItemStack variableAspect2 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH), Aspects.Read.Redstone.INTEGER_VALUE);
        variableStore.getInventory().setItem(0, variableAspect1);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.ARITHMETIC_ADDITION, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), variableAdded);
        helper.succeedWhen(() -> {
            helper.assertFalse(((PartTypePanelDisplay.State)partAndState.getRight()).isDeactivated(), (Component)Component.literal((String)"Display panel is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.DISPLAY_PANEL.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ERROR, (Component)Component.literal((String)"Block status is incorrect"));
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), null);
            helper.assertValueEqual(((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors(), (Object)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId())})}), (Component)Component.literal((String)"Display panel errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderAddOperatorToDisplayFullyDisconnected(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north(), BlockEntityVariablestore.class);
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        helper.setBlock(POS.south(), Blocks.REDSTONE_BLOCK);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        ItemStack variableAspect2 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH), Aspects.Read.Redstone.INTEGER_VALUE);
        variableStore.getInventory().setItem(0, variableAspect1);
        variableStore.getInventory().setItem(1, variableAspect2);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.ARITHMETIC_ADDITION, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST), variableAdded);
        helper.succeedWhen(() -> {
            helper.assertFalse(((PartTypePanelDisplay.State)partAndState.getRight()).isDeactivated(), (Component)Component.literal((String)"Display panel is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.DISPLAY_PANEL.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ERROR, (Component)Component.literal((String)"Block status is incorrect"));
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), null);
            helper.assertValueEqual(((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors(), (Object)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId())}), Component.translatable((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId())})}), (Component)Component.literal((String)"Display panel errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderAddOperatorToDisplayBecomesFullyDisconnected(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north(), BlockEntityVariablestore.class);
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        helper.setBlock(POS.south(), Blocks.REDSTONE_BLOCK);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        ItemStack variableAspect2 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH), Aspects.Read.Redstone.INTEGER_VALUE);
        variableStore.getInventory().setItem(0, variableAspect1);
        variableStore.getInventory().setItem(1, variableAspect2);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.ARITHMETIC_ADDITION, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST), variableAdded);
        helper.runAtTickTime(5L, () -> helper.destroyBlock(POS.east()));
        helper.succeedWhen(() -> {
            helper.assertFalse(((PartTypePanelDisplay.State)partAndState.getRight()).isDeactivated(), (Component)Component.literal((String)"Display panel is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.DISPLAY_PANEL.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ERROR, (Component)Component.literal((String)"Block status is incorrect"));
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), null);
            helper.assertValueEqual(((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors(), (Object)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId())}), Component.translatable((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId())})}), (Component)Component.literal((String)"Display panel errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderAddOperatorToDisplayReadersDisconnected(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.east().east().north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.east().east().north(), BlockEntityVariablestore.class);
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        helper.setBlock(POS.south(), Blocks.REDSTONE_BLOCK);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        ItemStack variableAspect2 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH), Aspects.Read.Redstone.INTEGER_VALUE);
        variableStore.getInventory().setItem(0, variableAspect1);
        variableStore.getInventory().setItem(1, variableAspect2);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.ARITHMETIC_ADDITION, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST), variableAdded);
        helper.succeedWhen(() -> {
            helper.assertFalse(((PartTypePanelDisplay.State)partAndState.getRight()).isDeactivated(), (Component)Component.literal((String)"Display panel is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.DISPLAY_PANEL.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ERROR, (Component)Component.literal((String)"Block status is incorrect"));
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), null);
            Object partStateReader1 = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST)).getState();
            Object partStateReader2 = PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH)).getState();
            helper.assertValueEqual(((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors(), (Object)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"variable.integrateddynamics.error.part_not_in_network", (Object[])new Object[]{Integer.toString(partStateReader1.getId())}), Component.translatable((String)"variable.integrateddynamics.error.part_not_in_network", (Object[])new Object[]{Integer.toString(partStateReader2.getId())})}), (Component)Component.literal((String)"Display panel errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderAddOperatorToDisplayVariableStoreDisconnected(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north().north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north().north(), BlockEntityVariablestore.class);
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        helper.setBlock(POS.south(), Blocks.REDSTONE_BLOCK);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        ItemStack variableAspect2 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH), Aspects.Read.Redstone.INTEGER_VALUE);
        variableStore.getInventory().setItem(0, variableAspect1);
        variableStore.getInventory().setItem(1, variableAspect2);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.ARITHMETIC_ADDITION, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), variableAdded);
        helper.succeedWhen(() -> {
            helper.assertFalse(((PartTypePanelDisplay.State)partAndState.getRight()).isDeactivated(), (Component)Component.literal((String)"Display panel is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.DISPLAY_PANEL.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ERROR, (Component)Component.literal((String)"Block status is incorrect"));
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), null);
            helper.assertValueEqual(((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors(), (Object)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId())}), Component.translatable((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId())})}), (Component)Component.literal((String)"Display panel errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testCombinedAspectsRedstoneReaderAddOperatorToDisplayBecomesFullyConnected(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north(), BlockEntityVariablestore.class);
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        helper.setBlock(POS.south(), Blocks.REDSTONE_BLOCK);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        ItemStack variableAspect2 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.SOUTH), Aspects.Read.Redstone.INTEGER_VALUE);
        variableStore.getInventory().setItem(0, variableAspect1);
        variableStore.getInventory().setItem(1, variableAspect2);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.ARITHMETIC_ADDITION, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect2).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east().east()), Direction.EAST), variableAdded);
        helper.runAtTickTime(5L, () -> helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value()));
        helper.succeedOnTickWhen(6, () -> GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeInteger.ValueInteger.of(29)));
    }
}

