/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest.integration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableIngredients;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableRecipe;

public class TestVariables {
    protected static Tag serializeStack(ItemStack itemStack) {
        return (Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)itemStack).getOrThrow(JsonParseException::new);
    }

    protected static Tag serializeFluidStack(FluidStack fluidStack) {
        return (Tag)FluidStack.OPTIONAL_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)fluidStack).getOrThrow(JsonParseException::new);
    }

    @IntegrationTest
    public void testIngredientsType() {
        DummyVariableIngredients inull = new DummyVariableIngredients(ValueObjectTypeIngredients.ValueIngredients.of(null));
        TestHelpers.assertEqual(((ValueObjectTypeIngredients.ValueIngredients)inull.getValue()).getRawValue().orElse(null), null, "null value is null");
        MixedIngredients ingredients1 = MixedIngredients.ofInstances((IngredientComponent)IngredientComponent.ITEMSTACK, (Collection)Lists.newArrayList((Object[])new ItemStack[]{ItemStack.EMPTY, new ItemStack((ItemLike)Items.OAK_BOAT), new ItemStack((ItemLike)Blocks.STONE), ItemStack.EMPTY}));
        DummyVariableIngredients i0 = new DummyVariableIngredients(ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)ingredients1));
        TestHelpers.assertEqual((IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)i0.getValue()).getRawValue().get(), ingredients1, "ingredient value is ingredient");
        CompoundTag tag = new CompoundTag();
        ListTag itemStacks = new ListTag();
        CompoundTag itemStack1 = new CompoundTag();
        itemStack1.put("i", TestVariables.serializeStack(ItemStack.EMPTY));
        itemStacks.add((Object)itemStack1);
        CompoundTag itemStack2 = new CompoundTag();
        itemStack2.put("i", TestVariables.serializeStack(new ItemStack((ItemLike)Items.OAK_BOAT)));
        itemStacks.add((Object)itemStack2);
        CompoundTag itemStack3 = new CompoundTag();
        itemStack3.put("i", TestVariables.serializeStack(new ItemStack((ItemLike)Blocks.STONE)));
        itemStacks.add((Object)itemStack3);
        CompoundTag itemStack4 = new CompoundTag();
        itemStack4.put("i", TestVariables.serializeStack(ItemStack.EMPTY));
        itemStacks.add((Object)itemStack4);
        ListTag ingredientsList = new ListTag();
        CompoundTag ingredientsListItemStacks = new CompoundTag();
        ingredientsListItemStacks.putString("component", "minecraft:itemstack");
        ingredientsListItemStacks.put("instances", (Tag)itemStacks);
        ingredientsList.add((Object)ingredientsListItemStacks);
        tag.put("v", (Tag)ingredientsList);
        CompoundTag tagRoot = new CompoundTag();
        tagRoot.put("v", (Tag)tag);
        TestHelpers.assertEqual(TestHelpers.serialize(o -> i0.getType().serialize((ValueOutput)o, (ValueObjectTypeIngredients.ValueIngredients)i0.getValue())), tagRoot, "Serialization is correct");
        TestHelpers.assertEqual(TestHelpers.deserialize(tagRoot, i0.getType()::deserialize), (ValueObjectTypeIngredients.ValueIngredients)i0.getValue(), "Deserialization is correct");
    }

    @IntegrationTest
    public void testRecipeType() {
        DummyVariableRecipe rnull = new DummyVariableRecipe(ValueObjectTypeRecipe.ValueRecipe.of(null));
        TestHelpers.assertEqual(((ValueObjectTypeRecipe.ValueRecipe)rnull.getValue()).getRawValue().orElse(null), null, "null value is null");
        ArrayList ingredientsIn = Lists.newArrayList();
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.OAK_BOAT), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)Blocks.STONE), (Object)13)));
        ingredientsIn.add(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)13)));
        IdentityHashMap ingredientsOut = Maps.newIdentityHashMap();
        ingredientsOut.put(IngredientComponent.ENERGY, Lists.newArrayList((Object[])new Long[]{777L}));
        ingredientsOut.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{new FluidStack((Fluid)Fluids.WATER, 123)}));
        ingredientsOut.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.OAK_BOAT), new ItemStack((ItemLike)Item.byBlock((Block)Blocks.STONE))}));
        DummyVariableIngredients iMainOut = new DummyVariableIngredients(ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)new MixedIngredients((Map)ingredientsOut)));
        RecipeDefinition rawRecipe = RecipeDefinition.ofIngredients((IngredientComponent)IngredientComponent.ITEMSTACK, (List)ingredientsIn, (IMixedIngredients)((IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)iMainOut.getValue()).getRawValue().get()));
        DummyVariableRecipe r0 = new DummyVariableRecipe(ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)rawRecipe));
        TestHelpers.assertEqual((IRecipeDefinition)((ValueObjectTypeRecipe.ValueRecipe)r0.getValue()).getRawValue().get(), rawRecipe, "recipe value is recipe");
        CompoundTag tag = new CompoundTag();
        CompoundTag output = new CompoundTag();
        ListTag outputList = new ListTag();
        output.put("v", (Tag)outputList);
        ListTag energies = new ListTag();
        CompoundTag energy = new CompoundTag();
        energy.putLong("i", 777L);
        energies.add((Object)energy);
        CompoundTag outputListEnergy = new CompoundTag();
        outputListEnergy.putString("component", "minecraft:energy");
        outputListEnergy.put("instances", (Tag)energies);
        outputList.add((Object)outputListEnergy);
        ListTag fluidStacks = new ListTag();
        CompoundTag fluidStack1 = new CompoundTag();
        fluidStack1.put("i", TestVariables.serializeFluidStack(new FluidStack((Fluid)Fluids.WATER, 123)));
        fluidStacks.add((Object)fluidStack1);
        CompoundTag outputListFluidStack = new CompoundTag();
        outputListFluidStack.putString("component", "minecraft:fluidstack");
        outputListFluidStack.put("instances", (Tag)fluidStacks);
        outputList.add((Object)outputListFluidStack);
        ListTag itemStacks = new ListTag();
        CompoundTag itemStack1 = new CompoundTag();
        itemStack1.put("i", TestVariables.serializeStack(new ItemStack((ItemLike)Items.OAK_BOAT)));
        itemStacks.add((Object)itemStack1);
        CompoundTag itemStack2 = new CompoundTag();
        itemStack2.put("i", TestVariables.serializeStack(new ItemStack((ItemLike)Blocks.STONE)));
        itemStacks.add((Object)itemStack2);
        CompoundTag outputListItemStack = new CompoundTag();
        outputListItemStack.putString("component", "minecraft:itemstack");
        outputListItemStack.put("instances", (Tag)itemStacks);
        outputList.add((Object)outputListItemStack);
        ListTag input = new ListTag();
        ListTag itemStacksIn = new ListTag();
        itemStacksIn.add((Object)new CompoundTag());
        itemStacksIn.add((Object)new CompoundTag());
        itemStacksIn.add((Object)new CompoundTag());
        itemStacksIn.add((Object)new CompoundTag());
        ListTag val0 = new ListTag();
        val0.add((Object)TestHelpers.serialize(o -> IPrototypedIngredient.serialize((ValueOutput)o, (IPrototypedIngredient)((IPrototypedIngredient)((List)ingredientsIn.get(0)).get(0)))));
        ((CompoundTag)val0.getCompound(0).get()).remove("ingredientComponent");
        CompoundTag val0l = new CompoundTag();
        val0l.put("l", (Tag)val0);
        ((CompoundTag)itemStacksIn.getCompound(0).get()).put("val", (Tag)val0l);
        ((CompoundTag)itemStacksIn.getCompound(0).get()).putByte("type", (byte)0);
        ListTag val1 = new ListTag();
        val1.add((Object)TestHelpers.serialize(o -> IPrototypedIngredient.serialize((ValueOutput)o, (IPrototypedIngredient)((IPrototypedIngredient)((List)ingredientsIn.get(1)).get(0)))));
        ((CompoundTag)val1.getCompound(0).get()).remove("ingredientComponent");
        CompoundTag val1l = new CompoundTag();
        val1l.put("l", (Tag)val1);
        ((CompoundTag)itemStacksIn.getCompound(1).get()).put("val", (Tag)val1l);
        ((CompoundTag)itemStacksIn.getCompound(1).get()).putByte("type", (byte)0);
        ListTag val2 = new ListTag();
        val2.add((Object)TestHelpers.serialize(o -> IPrototypedIngredient.serialize((ValueOutput)o, (IPrototypedIngredient)((IPrototypedIngredient)((List)ingredientsIn.get(2)).get(0)))));
        ((CompoundTag)val2.getCompound(0).get()).remove("ingredientComponent");
        CompoundTag val2l = new CompoundTag();
        val2l.put("l", (Tag)val2);
        ((CompoundTag)itemStacksIn.getCompound(2).get()).put("val", (Tag)val2l);
        ((CompoundTag)itemStacksIn.getCompound(2).get()).putByte("type", (byte)0);
        ListTag val3 = new ListTag();
        val3.add((Object)TestHelpers.serialize(o -> IPrototypedIngredient.serialize((ValueOutput)o, (IPrototypedIngredient)((IPrototypedIngredient)((List)ingredientsIn.get(3)).get(0)))));
        ((CompoundTag)val3.getCompound(0).get()).remove("ingredientComponent");
        CompoundTag val3l = new CompoundTag();
        val3l.put("l", (Tag)val3);
        ((CompoundTag)itemStacksIn.getCompound(3).get()).put("val", (Tag)val3l);
        ((CompoundTag)itemStacksIn.getCompound(3).get()).putByte("type", (byte)0);
        CompoundTag ingredientsListItemStacks = new CompoundTag();
        ingredientsListItemStacks.putString("component", "minecraft:itemstack");
        ingredientsListItemStacks.put("instances", (Tag)itemStacksIn);
        input.add((Object)ingredientsListItemStacks);
        int[] reusableBytes = new int[]{0, 0, 0, 0};
        IntArrayTag itemStacksReusable = new IntArrayTag(reusableBytes);
        ingredientsListItemStacks.put("reusable", (Tag)itemStacksReusable);
        tag.put("output", (Tag)output);
        tag.put("input", (Tag)input);
        CompoundTag topTag = new CompoundTag();
        topTag.put("v", (Tag)tag);
        TestHelpers.assertEqual(TestHelpers.serialize(o -> r0.getType().serialize((ValueOutput)o, (ValueObjectTypeRecipe.ValueRecipe)r0.getValue())), topTag, "Serialization is correct");
        TestHelpers.assertEqual(TestHelpers.deserialize(topTag, r0.getType()::deserialize), (ValueObjectTypeRecipe.ValueRecipe)r0.getValue(), "Deserialization is correct");
    }
}

