/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.cyclops.cyclopscore.RegistryEntries;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMechanicalMachine;

public class LootFunctionCopyMechanicalMachineEnergy
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyMechanicalMachineEnergy> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyMechanicalMachineEnergy.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyMechanicalMachineEnergy::new));
    public static final LootItemFunctionType<LootFunctionCopyMechanicalMachineEnergy> TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyMechanicalMachineEnergy(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        BlockEntity tile = (BlockEntity)lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityMechanicalMachine) {
            itemStack.set((Supplier)RegistryEntries.COMPONENT_ENERGY_STORAGE, (Object)((BlockEntityMechanicalMachine)tile).getEnergy());
        }
        return itemStack;
    }

    public LootItemFunctionType<LootFunctionCopyMechanicalMachineEnergy> getType() {
        return TYPE;
    }
}

