/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;

public abstract class OperatorBase
implements IOperator {
    private final String symbol;
    private final String operatorName;
    private final String interactName;
    @Nullable
    private final String globalInteractNamePrefix;
    private final boolean alsoPrefixLocalScope;
    private final IValueType[] inputTypes;
    private final IValueType outputType;
    private final IFunction function;
    @Nullable
    private final IConfigRenderPattern renderPattern;
    private String translationKey = null;
    private int recursiveInvocations;

    protected OperatorBase(String symbol, String operatorName, String interactName, String globalInteractNamePrefix, boolean alsoPrefixLocalScope, IValueType[] inputTypes, IValueType outputType, IFunction function, @Nullable IConfigRenderPattern renderPattern) {
        this.symbol = symbol;
        this.operatorName = operatorName;
        this.interactName = interactName;
        this.globalInteractNamePrefix = globalInteractNamePrefix;
        this.alsoPrefixLocalScope = alsoPrefixLocalScope;
        this.inputTypes = inputTypes;
        this.outputType = outputType;
        this.function = function;
        this.renderPattern = renderPattern;
        if (renderPattern != null && renderPattern.getSlotPositions().length != inputTypes.length) {
            throw new IllegalArgumentException(String.format("The given config render pattern with %s slots is not compatible with the number of input types %s for %s", renderPattern.getSlotPositions().length, inputTypes.length, symbol));
        }
    }

    public static IValueType[] constructInputVariables(int length, IValueType defaultType) {
        Object[] values = new IValueType[length];
        Arrays.fill(values, defaultType);
        return values;
    }

    protected abstract String getUnlocalizedType();

    protected IFunction getFunction() {
        return this.function;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)(this.getUnlocalizedType().replaceAll("\\.", "_") + "_" + this.getOperatorName()));
    }

    @Override
    public String getInteractName() {
        return this.interactName;
    }

    @Override
    @Nullable
    public String getGlobalInteractNamePrefix() {
        return this.globalInteractNamePrefix;
    }

    @Override
    public boolean shouldAlsoPrefixLocalScope() {
        return this.alsoPrefixLocalScope;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey != null ? this.translationKey : (this.translationKey = this.getUnlocalizedPrefix());
    }

    @Override
    public String getUnlocalizedCategoryName() {
        return this.getUnlocalizedCategoryPrefix();
    }

    @Override
    public MutableComponent getLocalizedNameFull() {
        return Component.translatable((String)(this.getUnlocalizedCategoryPrefix() + ".basename"), (Object[])new Object[]{Component.translatable((String)this.getTranslationKey())});
    }

    protected String getUnlocalizedPrefix() {
        return "operator." + this.getModId() + "." + this.getUnlocalizedType() + "." + this.getOperatorName();
    }

    protected String getUnlocalizedCategoryPrefix() {
        return "operator." + this.getModId() + "." + this.getUnlocalizedType();
    }

    protected String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void loadTooltip(Consumer<Component> tooltipAdder, boolean appendOptionalInfo) {
        MutableComponent operatorName = Component.translatable((String)this.getTranslationKey());
        MutableComponent categoryName = Component.translatable((String)this.getUnlocalizedCategoryName());
        String symbol = this.getSymbol();
        String outputTypeName = IModHelpers.get().getL10NHelpers().localize(this.getOutputType().getTranslationKey(), new Object[0]);
        tooltipAdder.accept((Component)Component.translatable((String)"operator.integrateddynamics.tooltip.operator_name", (Object[])new Object[]{operatorName, symbol}));
        tooltipAdder.accept((Component)Component.translatable((String)"operator.integrateddynamics.tooltip.operator_category", (Object[])new Object[]{categoryName}));
        IValueType[] inputTypes = this.getInputTypes();
        for (int i = 0; i < inputTypes.length; ++i) {
            tooltipAdder.accept((Component)Component.translatable((String)"operator.integrateddynamics.tooltip.input_type_name", (Object[])new Object[]{i + 1}).append((Component)Component.translatable((String)inputTypes[i].getTranslationKey())).withStyle(inputTypes[i].getDisplayColorFormat()));
        }
        tooltipAdder.accept((Component)Component.translatable((String)"operator.integrateddynamics.tooltip.output_type_name", (Object[])new Object[]{String.valueOf(this.getOutputType().getDisplayColorFormat()) + outputTypeName}));
        if (appendOptionalInfo) {
            MutableComponent globalNameComponent = Component.translatable((String)"gui.integrateddynamics.operator.globalname", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + this.getGlobalInteractName() + "("}).withStyle(ChatFormatting.YELLOW);
            for (int i = 0; i < inputTypes.length; ++i) {
                if (i > 0) {
                    globalNameComponent = globalNameComponent.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.WHITE));
                }
                globalNameComponent = globalNameComponent.append((Component)Component.translatable((String)inputTypes[i].getTranslationKey()).withStyle(inputTypes[i].getDisplayColorFormat()));
            }
            tooltipAdder.accept((Component)globalNameComponent.append((Component)Component.literal((String)")").withStyle(ChatFormatting.WHITE)));
            if (this.getInputTypes().length > 0) {
                String scopedTypeName = IModHelpers.get().getL10NHelpers().localize(this.getInputTypes()[0].getTranslationKey(), new Object[0]);
                MutableComponent localNameComponent = Component.translatable((String)"gui.integrateddynamics.operator.localname", (Object[])new Object[]{String.valueOf(this.getInputTypes()[0].getDisplayColorFormat()) + scopedTypeName + "." + String.valueOf(ChatFormatting.WHITE) + this.getScopedInteractName() + "("}).withStyle(ChatFormatting.YELLOW);
                for (int i = 1; i < inputTypes.length; ++i) {
                    if (i > 1) {
                        localNameComponent = localNameComponent.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.WHITE));
                    }
                    localNameComponent = localNameComponent.append((Component)Component.translatable((String)inputTypes[i].getTranslationKey()).withStyle(inputTypes[i].getDisplayColorFormat()));
                }
                tooltipAdder.accept((Component)localNameComponent.append((Component)Component.literal((String)")").withStyle(ChatFormatting.WHITE)));
            }
            IModHelpers.get().getL10NHelpers().addOptionalInfo(tooltipAdder, this.getUnlocalizedPrefix());
        }
    }

    @Override
    public IValueType[] getInputTypes() {
        return this.inputTypes;
    }

    @Override
    public IValueType getOutputType() {
        return this.outputType;
    }

    @Override
    public IValueType getConditionalOutputType(IVariable[] input) {
        return this.outputType;
    }

    @Override
    public IValue evaluate(IVariable ... input) throws EvaluationException {
        if (this.recursiveInvocations++ > GeneralConfig.operatorRecursionLimit) {
            this.recursiveInvocations = 0;
            throw new EvaluationException(Component.translatable((String)"operator.integrateddynamics.error.operator_recursion_limit", (Object[])new Object[]{GeneralConfig.operatorRecursionLimit, Component.translatable((String)this.getTranslationKey())}));
        }
        MutableComponent error = this.validateTypes(ValueHelpers.from(input));
        if (error != null) {
            --this.recursiveInvocations;
            throw new EvaluationException(error);
        }
        IValue res = this.function.evaluate(new SafeVariablesGetter(input));
        --this.recursiveInvocations;
        return res;
    }

    @Override
    public int getRequiredInputLength() {
        return this.getInputTypes().length;
    }

    @Override
    public MutableComponent validateTypes(IValueType[] input) {
        int requiredInputLength = this.getRequiredInputLength();
        if (input.length != requiredInputLength) {
            return Component.translatable((String)"operator.integrateddynamics.error.wrong_input_length", (Object[])new Object[]{this.getOperatorName(), input.length, requiredInputLength});
        }
        for (int i = 0; i < requiredInputLength; ++i) {
            IValueType inputType = input[i];
            if (inputType == null) {
                return Component.translatable((String)"operator.integrateddynamics.error.null_type", (Object[])new Object[]{this.getOperatorName(), Integer.toString(i)});
            }
            if (ValueHelpers.correspondsTo(this.getInputTypes()[i], inputType)) continue;
            return Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{this.getOperatorName(), Component.translatable((String)inputType.getTranslationKey()), Integer.toString(i + 1), Component.translatable((String)this.getInputTypes()[i].getTranslationKey())});
        }
        return null;
    }

    public String toString() {
        return "[Operator: " + this.getOperatorName() + "]";
    }

    protected String getModId() {
        return "integrateddynamics";
    }

    @Override
    @Nullable
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public IOperator materialize() throws EvaluationException {
        return this;
    }

    public static interface IFunction {
        public IValue evaluate(SafeVariablesGetter var1) throws EvaluationException;
    }

    public static class SafeVariablesGetter {
        private final IVariable[] variables;

        public SafeVariablesGetter(IVariable ... variables) {
            this.variables = variables;
        }

        public IValue getValue(int i) throws EvaluationException {
            return this.variables[i].getValue();
        }

        public <V extends IValue> V getValue(int i, IValueType<V> valueType) throws EvaluationException {
            return valueType.cast(this.getValue(i));
        }

        public IVariable[] getVariables() {
            return this.variables;
        }

        public static class Shifted
        extends SafeVariablesGetter {
            public Shifted(int start, IVariable ... variables) {
                super(Arrays.copyOfRange(variables, start, variables.length));
            }
        }
    }
}

