/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer.client;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementClient;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeIngredientsLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.ValueTypeLPElementBaseClient;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerSetElementInventory;

public class ValueTypeIngredientsLPElementClient
extends ValueTypeLPElementBaseClient<ValueTypeIngredientsLPElement> {
    private MasterSubGuiRenderPattern masterGui;
    private Map<IngredientComponent, Map<Integer, RenderPattern>> subElementGuis = Maps.newHashMap();

    public ValueTypeIngredientsLPElementClient(ValueTypeIngredientsLPElement element) {
        super(element);
    }

    @Override
    public void setValueInGui(ISubGuiBox subGui) {
        if (!((ValueTypeIngredientsLPElement)this.getElement()).getSubElements().get(((ValueTypeIngredientsLPElement)this.getElement()).getCurrentType()).isEmpty()) {
            ((ValueTypeIngredientsLPElement)this.getElement()).setActiveElement(0);
        }
    }

    @Override
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.masterGui = new MasterSubGuiRenderPattern((ValueTypeIngredientsLPElement)this.getElement(), baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.masterGui;
    }

    public void setActiveElement(int activeElement) {
        if (this.masterGui != null) {
            this.masterGui.setActiveElement(activeElement);
            this.masterGui.container.onDirty();
        }
    }

    public void removeElement(int index) {
        IngredientComponent currentType = ((ValueTypeIngredientsLPElement)this.getElement()).getCurrentType();
        Map<Integer, RenderPattern> oldSubElementGuis = this.subElementGuis.get(currentType);
        this.subElementGuis.put(currentType, Maps.newHashMap());
        for (Map.Entry<Integer, RenderPattern> entry : oldSubElementGuis.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElementGuis.get(currentType).put(i, entry.getValue());
                continue;
            }
            if (i <= index) continue;
            this.subElementGuis.get(currentType).put(i - 1, entry.getValue());
        }
    }

    public void activate() {
        for (IngredientComponent<?, ?> recipeComponent : IngredientComponentHandlers.REGISTRY.getComponents()) {
            this.subElementGuis.put(recipeComponent, Maps.newHashMap());
        }
    }

    protected static class MasterSubGuiRenderPattern
    extends RenderPattern<ValueTypeIngredientsLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IRenderPatternValueTypeTooltip {
        private final int baseX;
        private final int baseY;
        private final int maxWidth;
        private final int maxHeight;
        private final ContainerScreenLogicProgrammerBase gui;
        private final ContainerLogicProgrammerBase container;
        protected ListElementSubGui elementSubGui = null;
        protected int lastGuiLeft;
        protected int lastGuiTop;
        private boolean renderTooltip = true;

        public MasterSubGuiRenderPattern(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGuiHolder.addSubGui(new SelectionSubGui(element, baseX, baseY, maxWidth, maxHeight, gui, container));
            this.baseX = baseX;
            this.baseY = baseY;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.gui = gui;
            this.container = container;
        }

        public void setActiveElement(int index) {
            if (this.elementSubGui != null) {
                this.subGuiHolder.removeSubGui(this.elementSubGui);
                ((ContainerLogicProgrammerBase)this.gui.getMenu()).setElementInventory(null, 0, 0);
            }
            if (index >= 0) {
                this.elementSubGui = new ListElementSubGui((ValueTypeIngredientsLPElement)this.element, this.baseX, this.baseY + this.getHeight() / 4, this.maxWidth, this.maxHeight, this.gui, this.container);
                this.subGuiHolder.addSubGui(this.elementSubGui);
                this.elementSubGui.init(this.lastGuiLeft, this.lastGuiTop);
            }
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }

        @Override
        public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            this.drawTooltipForeground(this.gui, guiGraphics, this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeIngredientsLPElement)this.element).getValueType());
        }

        @Override
        public boolean isRenderTooltip() {
            return this.renderTooltip;
        }

        @Override
        public void setRenderTooltip(boolean renderTooltip) {
            this.renderTooltip = renderTooltip;
        }
    }

    protected static class ListElementSubGui
    extends RenderPattern<ValueTypeIngredientsLPElement, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> {
        private ButtonArrow arrowLeft;
        private ButtonArrow arrowRight;
        private Button arrowRemove;
        private RenderPattern subGui;
        private IValueTypeLogicProgrammerElement<RenderPattern, ContainerScreenLogicProgrammerBase<?>, AbstractContainerMenu, ?> subElement;

        public ListElementSubGui(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase<?> gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGui = ((ValueTypeIngredientsLPElementClient)element.getClient()).subElementGuis.get(element.getCurrentType()).get(element.getActiveElement());
            this.subElement = element.getSubElements().get(element.getCurrentType()).get(element.getActiveElement());
            if (this.subGui == null) {
                this.subGui = (RenderPattern)((ILogicProgrammerElementClient)this.subElement.getClient()).createSubGui(baseX, baseY, maxWidth, maxHeight / 3 * 2, gui, container);
                ((ValueTypeIngredientsLPElementClient)element.getClient()).subElementGuis.get(element.getCurrentType()).put(element.getActiveElement(), this.subGui);
            }
            int x = this.getX() + baseX - 20;
            int y = this.getY() + baseY - 21;
            ((ContainerLogicProgrammerBase)gui.getMenu()).setElementInventory(this.subElement, x, y);
            this.subGuiHolder.addSubGui(this.subGui);
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerSetElementInventory((IValueType)IngredientComponentHandlers.REGISTRY.getComponentHandler(element.getCurrentType()).getValueType(), x, y));
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4 * 3;
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowLeft = new ButtonArrow(x, y, (Component)Component.translatable((String)"gui.cyclopscore.left"), b -> ((ValueTypeIngredientsLPElement)this.element).setActiveElement(((ValueTypeIngredientsLPElement)this.element).getActiveElement() - 1), ButtonArrow.Direction.WEST);
            this.buttonList.add(this.arrowLeft);
            this.arrowRight = new ButtonArrow(x + this.getWidth() - this.arrowLeft.getWidth() - 1, y, (Component)Component.translatable((String)"gui.cyclopscore.right"), b -> ((ValueTypeIngredientsLPElement)this.element).setActiveElement(((ValueTypeIngredientsLPElement)this.element).getActiveElement() + 1), ButtonArrow.Direction.EAST);
            this.buttonList.add(this.arrowRight);
            this.arrowRemove = new ButtonText(x + this.getWidth() / 2 - this.arrowLeft.getWidth() / 2, y + this.getHeight() - 13, 12, 12, (Component)Component.translatable((String)"gui.integrateddynamics.button.remove"), (Component)Component.literal((String)"-"), b -> ((ValueTypeIngredientsLPElement)this.element).removeElement(((ValueTypeIngredientsLPElement)this.element).getActiveElement()), true);
            this.buttonList.add(this.arrowRemove);
            this.arrowLeft.active = ((ValueTypeIngredientsLPElement)this.element).getActiveElement() > 0;
            this.arrowRight.active = ((ValueTypeIngredientsLPElement)this.element).getActiveElement() < ((ValueTypeIngredientsLPElement)this.element).getLength() - 1;
            this.arrowRemove.active = ((ValueTypeIngredientsLPElement)this.element).getLength() > 0;
            ((ILogicProgrammerElementClient)this.subElement.getClient()).setValueInGui(this.subGui);
            this.subElement.setValueInContainer((AbstractContainerMenu)this.subGui.container);
        }

        @Override
        public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            int x = guiLeft + this.getX() + this.getWidth() / 2;
            int y = guiTop + this.getY() + 4;
            IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, fontRenderer, String.valueOf(((ValueTypeIngredientsLPElement)this.element).getActiveElement()), x - 4, y + 2, 10, IModHelpers.get().getBaseHelpers().RGBAToInt(20, 20, 20, 255), false, Font.DisplayMode.NORMAL);
        }
    }

    protected static class SelectionSubGui
    extends RenderPattern<ValueTypeIngredientsLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IInputListener {
        private WidgetArrowedListField<IngredientComponent<?, ?>> valueTypeSelector = null;
        private Button arrowAdd;

        public SelectionSubGui(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4;
        }

        protected static List<IngredientComponent<?, ?>> getValueTypes() {
            return IngredientComponentHandlers.REGISTRY.getComponents().stream().sorted(Comparator.comparing(IngredientComponent::getName).reversed()).toList();
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.valueTypeSelector = new WidgetArrowedListField<IngredientComponent<?, ?>>(this, Minecraft.getInstance().font, this.getX() + guiLeft + this.getWidth() / 2 - 50, this.getY() + guiTop + 2, 100, 15, true, (Component)Component.translatable((String)"valuetype.integrateddynamics.value_type"), true, SelectionSubGui.getValueTypes()){

                protected String activeElementToString(IngredientComponent element) {
                    return IModHelpers.get().getL10NHelpers().localize(element.getTranslationKey(), new Object[0]);
                }
            };
            this.valueTypeSelector.setListener((IInputListener)this);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowAdd = new ButtonText(x + this.getWidth() - 13, y + this.getHeight() - 13, 12, 12, (Component)Component.translatable((String)"gui.integrateddynamics.button.add"), (Component)Component.literal((String)"+"), b -> {}, true);
            this.buttonList.add(this.arrowAdd);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            return super.mouseClicked(mouseX, mouseY, mouseButton) || this.valueTypeSelector.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void actionPerformed(Button guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowAdd) {
                ((ValueTypeIngredientsLPElement)this.element).setLength(((ValueTypeIngredientsLPElement)this.element).getLength() + 1);
            }
        }

        @Override
        public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.valueTypeSelector.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public void onChanged() {
            ((ValueTypeIngredientsLPElement)this.element).setCurrentType((IngredientComponent)this.valueTypeSelector.getActiveElement());
        }
    }
}

