/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.persist.world;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.network.packet.ActionLabelPacket;
import org.cyclops.integrateddynamics.network.packet.AllLabelsPacket;

public class LabelsWorldStorage
extends WorldStorage<LabelsWorldStorage> {
    private final Map<Integer, String> labels;

    public LabelsWorldStorage(Map<Integer, String> labels) {
        this.labels = Maps.newHashMap(labels);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public synchronized void putUnsafe(int variableId, @Nonnull String label) {
        Objects.requireNonNull(label);
        this.labels.put(variableId, label);
        this.setDirty();
    }

    public synchronized void removeUnsafe(int variableId) {
        this.labels.remove(variableId);
        this.setDirty();
    }

    public void put(int variableId, @Nonnull String label) {
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new ActionLabelPacket(variableId, label));
        } else {
            this.putUnsafe(variableId, label);
            IntegratedDynamics._instance.getPacketHandler().sendToAll((PacketBase)new ActionLabelPacket(variableId, label));
        }
    }

    public void remove(int variableId) {
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new ActionLabelPacket(variableId, null));
        } else {
            this.removeUnsafe(variableId);
            IntegratedDynamics._instance.getPacketHandler().sendToAll((PacketBase)new ActionLabelPacket(variableId, null));
        }
    }

    public synchronized String getLabel(int variableId) {
        if (variableId < 0) {
            return null;
        }
        return this.labels.get(variableId);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            IntegratedDynamics._instance.getPacketHandler().sendToPlayer((PacketBase)new AllLabelsPacket(this.labels), (ServerPlayer)event.getEntity());
        }
    }

    public void afterLoad() {
        super.afterLoad();
        int sizeBefore = this.labels.size();
        this.labels.entrySet().removeIf(integerStringEntry -> integerStringEntry.getValue() == null);
        if (sizeBefore != this.labels.size()) {
            this.setDirty();
        }
    }

    public void clear() {
        this.labels.clear();
    }

    public static class Access
    extends WorldStorage.Access<LabelsWorldStorage> {
        private static Access INSTANCE = null;
        private LabelsWorldStorage clientInstance;

        public static Access getInstance(ModBaseNeoForge mod) {
            if (INSTANCE == null) {
                INSTANCE = new Access(mod);
            }
            return INSTANCE;
        }

        public Access(ModBaseNeoForge<?> mod) {
            super(new SavedDataType(mod.getModId() + "_labels", ctx -> new LabelsWorldStorage(Maps.newHashMap()), ctx -> RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)ctx.levelOrThrow()), (App)NeoForgeExtraCodecs.unboundedMapAsList((String)"k", (Codec)Codec.INT, (String)"v", (Codec)Codec.STRING).fieldOf("counters").forGetter(data -> data.labels)).apply((Applicative)instance, (level, labels) -> new LabelsWorldStorage((Map<Integer, String>)labels)))), mod);
        }

        public LabelsWorldStorage get() {
            if (IModHelpers.get().getMinecraftHelpers().isClientSide()) {
                if (this.clientInstance == null) {
                    this.clientInstance = new LabelsWorldStorage(Maps.newHashMap());
                }
                return this.clientInstance;
            }
            return (LabelsWorldStorage)super.get();
        }
    }
}

