/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.PacketCodecs;
import org.cyclops.integrateddynamics.client.render.level.PartOffsetsOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.PartOffsetsClientNotifier;

public class PartOffsetsDataPacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<PartOffsetsDataPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"part_offsets_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PartOffsetsDataPacket> CODEC = PartOffsetsDataPacket.getCodec(PartOffsetsDataPacket::new);
    @CodecField
    private List<PartOffsetsClientNotifier.Entry> offsets;

    public PartOffsetsDataPacket() {
        super(ID);
    }

    public PartOffsetsDataPacket(List<PartOffsetsClientNotifier.Entry> offsets) {
        super(ID);
        this.offsets = offsets;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
        PartOffsetsOverlayRenderer.getInstance().setData(this.offsets);
    }

    public void actionServer(Level world, ServerPlayer player) {
    }

    static {
        PacketCodecs.addCodedAction(PartOffsetsClientNotifier.Entry.class, (PacketCodec.ICodecAction)new PacketCodec.ICodecAction(){

            public void encode(Object object, RegistryFriendlyByteBuf output) {
                PartOffsetsClientNotifier.Entry entry = (PartOffsetsClientNotifier.Entry)object;
                PacketCodecs.getAction(BlockPos.class).encode((Object)entry.source(), output);
                PacketCodecs.getAction(Direction.class).encode((Object)entry.sourceSide(), output);
                PacketCodecs.getAction(Vec3i.class).encode((Object)entry.targetOffset(), output);
                PacketCodecs.getAction(Direction.class).encode((Object)entry.targetSide(), output);
            }

            public Object decode(RegistryFriendlyByteBuf input) {
                return new PartOffsetsClientNotifier.Entry((BlockPos)PacketCodecs.getAction(BlockPos.class).decode(input), (Direction)PacketCodecs.getAction(Direction.class).decode(input), (Vec3i)PacketCodecs.getAction(Vec3i.class).decode(input), (Direction)PacketCodecs.getAction(Direction.class).decode(input));
            }
        });
    }
}

