/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeStringLPElement;

public abstract class ValueTypeBase<V extends IValue>
implements IValueType<V> {
    private final String typeName;
    private final int color;
    private final ChatFormatting colorFormat;
    private final Class<V> valueClass;
    private String translationKey = null;

    public ValueTypeBase(String typeName, int color, ChatFormatting colorFormat, Class<V> valueClass) {
        this.typeName = typeName;
        this.color = color;
        this.colorFormat = colorFormat;
        this.valueClass = valueClass;
        if (MinecraftHelpers.isModdedEnvironment() && MinecraftHelpers.isClientSide()) {
            this.registerModelResourceLocation();
        }
    }

    @Override
    public boolean isCategory() {
        return false;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)this.getTypeName());
    }

    protected String getUnlocalizedPrefix() {
        return "valuetype." + this.getModId() + this.getTypeNamespace() + this.getTypeName();
    }

    protected String getTypeNamespace() {
        return ".";
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey != null ? this.translationKey : (this.translationKey = this.getUnlocalizedPrefix());
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int getDisplayColor() {
        return this.color;
    }

    @Override
    public ChatFormatting getDisplayColorFormat() {
        return this.colorFormat;
    }

    @Override
    public boolean correspondsTo(IValueType<?> valueType) {
        return this == valueType;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void registerModelResourceLocation() {
        ValueTypes.REGISTRY.registerValueTypeModel(this, ResourceLocation.parse((String)(this.getModId() + ":valuetype" + this.getTypeNamespace().replace('.', '/') + this.getTypeName().replace('.', '/'))));
    }

    @Override
    public void loadTooltip(List<Component> lines, boolean appendOptionalInfo, @Nullable V value) {
        String typeName = L10NHelpers.localize((String)this.getTranslationKey(), (Object[])new Object[0]);
        lines.add((Component)Component.translatable((String)"valuetype.integrateddynamics.tooltip.type_name", (Object[])new Object[]{String.valueOf(this.getDisplayColorFormat()) + typeName}));
        if (appendOptionalInfo) {
            L10NHelpers.addOptionalInfo(lines, (String)this.getUnlocalizedPrefix());
        }
    }

    @Override
    public Component canDeserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        try {
            this.deserialize(valueDeseralizationContext, value);
            return null;
        }
        catch (IllegalArgumentException e) {
            return Component.translatable((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{value});
        }
    }

    @Override
    public V materialize(V value) throws EvaluationException {
        return value;
    }

    @Override
    public V parseString(String value) throws EvaluationException {
        throw new UnsupportedOperationException("parseString is not supported on value type " + String.valueOf(this));
    }

    @Override
    public String toString(V value) {
        throw new UnsupportedOperationException("toString is not supported on value type " + String.valueOf(this));
    }

    public String toString() {
        return L10NHelpers.localize((String)this.getTranslationKey(), (Object[])new Object[0]);
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeStringLPElement((IValueType)this);
    }

    protected String getModId() {
        return "integrateddynamics";
    }

    @Override
    public V cast(IValue value) throws EvaluationException {
        try {
            return (V)((IValue)this.valueClass.cast(value));
        }
        catch (ClassCastException e) {
            throw new EvaluationException(Component.translatable((String)"operator.integrateddynamics.error.cast.illegal", (Object[])new Object[]{Component.translatable((String)value.getType().getTranslationKey()), Component.translatable((String)this.getTranslationKey()), value.getType().toCompactString(value)}));
        }
    }
}

