/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;

public interface IPartType<P extends IPartType<P, S>, S extends IPartState<P>>
extends INetworkEventListener<IPartNetworkElement<P, S>> {
    public ResourceLocation getUniqueName();

    public String getTranslationKey();

    public ResourceLocation getBlockModelPath();

    public Item getItem();

    public boolean isSolid(S var1);

    public PartRenderPosition getPartRenderPosition();

    public void serializeState(ValueOutput var1, S var2);

    public S deserializeState(ValueInput var1);

    public S defaultBlockState();

    public void setUpdateInterval(S var1, int var2);

    public int getUpdateInterval(S var1);

    public int getMinimumUpdateInterval(S var1);

    @Deprecated
    public void setPriorityAndChannel(INetwork var1, IPartNetwork var2, PartTarget var3, S var4, int var5, int var6);

    public int getPriority(S var1);

    public int getChannel(S var1);

    default public boolean supportsOffsets() {
        return true;
    }

    public Vec3i getTargetOffset(S var1);

    public boolean setTargetOffset(S var1, PartPos var2, Vec3i var3);

    public void setTargetSideOverride(S var1, @Nullable Direction var2);

    @Nullable
    public Direction getTargetSideOverride(S var1);

    public PartTarget getTarget(PartPos var1, S var2);

    public void onOffsetVariablesChanged(PartTarget var1, S var2);

    public boolean isUpdate(S var1);

    public void update(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void beforeNetworkKill(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void afterNetworkAlive(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void afterNetworkReAlive(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public ItemStack getItemStack(ValueDeseralizationContext var1, ProblemReporter.PathElement var2, S var3, boolean var4);

    public ItemStack getCloneItemStack(Level var1, BlockPos var2, S var3);

    public S getState(ValueDeseralizationContext var1, ProblemReporter.PathElement var2, ItemStack var3);

    public void addDrops(PartTarget var1, S var2, List<ItemStack> var3, boolean var4, boolean var5);

    public void onNetworkAddition(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void onNetworkRemoval(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public INetworkElement createNetworkElement(IPartContainer var1, DimPos var2, Direction var3);

    public InteractionResult onPartActivated(S var1, BlockPos var2, Level var3, Player var4, InteractionHand var5, ItemStack var6, BlockHitResult var7);

    public BlockState getBlockState(IPartContainer var1, Direction var2);

    public BlockState getBaseBlockState();

    public void updateTick(Level var1, BlockPos var2, S var3, RandomSource var4);

    public void onPreRemoved(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    public void onPostRemoved(INetwork var1, IPartNetwork var2, PartTarget var3, S var4);

    @Deprecated
    public void onBlockNeighborChange(@Nullable INetwork var1, @Nullable IPartNetwork var2, PartTarget var3, S var4, BlockGetter var5);

    default public void onBlockNeighborChange(@Nullable INetwork network, @Nullable IPartNetwork partNetwork, PartTarget target, S state, BlockGetter world, @Nullable Direction side) {
    }

    public int getConsumptionRate(S var1);

    public void postUpdate(INetwork var1, IPartNetwork var2, PartTarget var3, S var4, boolean var5);

    public boolean isEnabled(S var1);

    public void setEnabled(S var1, boolean var2);

    public void loadTooltip(S var1, List<Component> var2);

    public void loadTooltip(ItemStack var1, Consumer<Component> var2);

    public boolean shouldTriggerBlockRenderUpdate(@Nullable S var1, @Nullable S var2);

    public boolean forceLightTransparency(S var1);

    default public Optional<MenuProvider> getContainerProvider(PartPos pos) {
        return Optional.empty();
    }

    default public void writeExtraGuiData(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
    }

    default public Optional<MenuProvider> getContainerProviderSettings(PartPos pos) {
        return Optional.empty();
    }

    default public Optional<MenuProvider> getContainerProviderOffsets(PartPos pos) {
        return Optional.empty();
    }

    default public void writeExtraGuiDataSettings(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
    }

    default public void writeExtraGuiDataOffsets(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
    }
}

