/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Iterables;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipeClient;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;

public class ValueObjectTypeRecipe
extends ValueObjectTypeBase<ValueRecipe>
implements IValueTypeNamed<ValueRecipe>,
IValueTypeNullable<ValueRecipe> {
    public ValueObjectTypeRecipe() {
        super("recipe", ValueRecipe.class);
    }

    protected ValueObjectTypeRecipeClient constructClient() {
        return new ValueObjectTypeRecipeClient(this);
    }

    @Override
    public ValueRecipe getDefault() {
        return ValueRecipe.of(null);
    }

    @Override
    public MutableComponent toCompactString(ValueRecipe value) {
        if (value.getRawValue().isPresent()) {
            IRecipeDefinition recipe = (IRecipeDefinition)value.getRawValue().get();
            MutableComponent sb = Component.literal((String)"");
            sb.append((Component)ValueObjectTypeIngredients.ingredientsToTextComponent(recipe.getOutput()));
            sb.append((Component)Component.literal((String)" <- "));
            boolean first = true;
            for (IngredientComponent component : recipe.getInputComponents()) {
                IIngredientComponentHandler handler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                int i = 0;
                for (IPrototypedIngredientAlternatives instances : recipe.getInputs(component)) {
                    IPrototypedIngredient prototypedIngredient = (IPrototypedIngredient)Iterables.getFirst((Iterable)instances.getAlternatives(), null);
                    Object v = prototypedIngredient == null ? handler.getValueType().getDefault() : handler.toValue(prototypedIngredient.getPrototype());
                    if (!first) {
                        sb.append((Component)Component.literal((String)", "));
                    } else {
                        first = false;
                    }
                    sb.append(handler.toCompactString(v));
                    if (recipe.isInputReusable(component, i)) {
                        sb.append("*");
                    }
                    ++i;
                }
            }
            return sb;
        }
        return Component.literal((String)"");
    }

    @Override
    public void serialize(ValueOutput valueOutput, ValueRecipe value) {
        value.getRawValue().ifPresent(v -> IRecipeDefinition.serialize((ValueOutput)valueOutput.child("v"), (IRecipeDefinition)v));
    }

    @Override
    public ValueRecipe deserialize(ValueInput valueInput) {
        return ValueRecipe.of(valueInput.child("v").map(IRecipeDefinition::deserialize).orElse(null));
    }

    @Override
    public String getName(ValueRecipe a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueRecipe a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeRecipeLPElement();
    }

    public static class ValueRecipe
    extends ValueOptionalBase<IRecipeDefinition> {
        private ValueRecipe(IRecipeDefinition recipe) {
            super(ValueTypes.OBJECT_RECIPE, recipe);
        }

        public static ValueRecipe of(IRecipeDefinition recipe) {
            return new ValueRecipe(recipe);
        }

        @Override
        protected boolean isEqual(IRecipeDefinition a, IRecipeDefinition b) {
            return a.equals((Object)b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeRecipe.ValueRecipe()";
        }
    }
}

