/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemPart<P extends IPartType<P, S>, S extends IPartState<P>>
extends Item {
    private static final List<IUseAction> USE_ACTIONS = Lists.newArrayList();
    private final IPartType<P, S> part;

    public ItemPart(Item.Properties properties, IPartType<P, S> part) {
        super(properties);
        this.part = part;
    }

    public IPartType<P, S> getPart() {
        return this.part;
    }

    public static void addUseAction(IUseAction useAction) {
        USE_ACTIONS.add(useAction);
    }

    public Component getName(ItemStack p_200295_1_) {
        return Component.translatable((String)this.getDescriptionId());
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        BlockState blockState = world.getBlockState(pos);
        ItemStack itemStack = player.getItemInHand(hand);
        IPartContainer partContainerFirst = PartHelpers.getPartContainer((ILevelExtension)world, pos, side, blockState).orElse(null);
        if (partContainerFirst != null) {
            if (PartHelpers.addPart(world, pos, side, this.getPart(), itemStack)) {
                if (world.isClientSide()) {
                    ItemBlockCable.playPlaceSound(world, pos);
                }
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        BlockPos target = pos.relative(side);
        Direction targetSide = side.getOpposite();
        BlockHitResult targetRayTrace = new BlockHitResult(new Vec3((double)target.getX() + 0.5 + (double)targetSide.getStepX() * 0.5, (double)target.getY() + 0.5 + (double)targetSide.getStepY() * 0.5, (double)target.getZ() + 0.5 + (double)targetSide.getStepZ() * 0.5), targetSide, target, false);
        if (world.getBlockState(target).canBeReplaced(new BlockPlaceContext(world, player, hand, itemStack, targetRayTrace.withPosition(target)))) {
            BlockState targetBlockState;
            IPartContainer partContainer;
            ItemBlockCable itemBlockCable = (ItemBlockCable)Item.byBlock((Block)((Block)RegistryEntries.BLOCK_CABLE.get()));
            itemStack.grow(1);
            if (itemBlockCable.useOn(new UseOnContext(player, hand, targetRayTrace)).consumesAction() && (partContainer = (IPartContainer)PartHelpers.getPartContainer((ILevelExtension)world, target, targetSide, targetBlockState = world.getBlockState(target)).orElse(null)) != null) {
                ICableFakeable cableFakeable = CableHelpers.getCableFakeable((ILevelExtension)world, target, targetSide, targetBlockState).orElse(null);
                if (!world.isClientSide()) {
                    PartHelpers.addPart(world, target, side.getOpposite(), this.getPart(), itemStack);
                    if (cableFakeable != null) {
                        CableHelpers.onCableRemoving(world, target, false, false, world.getBlockState(target), world.getBlockEntity(target));
                        cableFakeable.setRealCable(false);
                        CableHelpers.overrideCableRemovingConnections(world, target, CableHelpers.ALL_SIDES);
                        CableHelpers.onCableRemoved(world, target);
                    } else {
                        IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("Tried to set a fake cable at a block that is not fakeable at %s", target));
                    }
                } else {
                    cableFakeable.setRealCable(false);
                }
                itemStack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            itemStack.shrink(1);
        } else {
            BlockState targetBlockState = world.getBlockState(target);
            IPartContainer partContainer = PartHelpers.getPartContainer((ILevelExtension)world, target, targetSide, targetBlockState).orElse(null);
            if (partContainer != null) {
                if (!world.isClientSide() && NetworkHelpers.getNetwork(PartPos.of(world, pos, side)).isPresent() && partContainer.canAddPart(targetSide, this.getPart())) {
                    CableHelpers.getCable((ILevelExtension)world, target, targetSide).ifPresent(cable -> CableHelpers.disconnectCable(world, target, targetSide, cable, targetSide));
                }
                if (PartHelpers.addPart(world, target, side.getOpposite(), this.getPart(), itemStack)) {
                    if (world.isClientSide()) {
                        ItemBlockCable.playPlaceSound(world, target);
                    }
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        for (IUseAction useAction : USE_ACTIONS) {
            if (!useAction.attempItemUseTarget(this, itemStack, world, pos, side)) continue;
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        this.getPart().loadTooltip(itemStack, tooltipAdder);
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemPart)) {
            return false;
        }
        ItemPart other = (ItemPart)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IPartType<P, S> this$part = this.getPart();
        IPartType<P, S> other$part = other.getPart();
        return !(this$part == null ? other$part != null : !this$part.equals(other$part));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemPart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPartType<P, S> $part = this.getPart();
        result = result * 59 + ($part == null ? 43 : $part.hashCode());
        return result;
    }

    public static interface IUseAction {
        public boolean attempItemUseTarget(ItemPart var1, ItemStack var2, Level var3, BlockPos var4, Direction var5);
    }
}

