/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest.integration;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integrateddynamics.gametest.integration.Asserts;
import org.cyclops.integrateddynamics.gametest.integration.DummyValueType;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariable;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableEntity;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableItemStack;
import org.cyclops.integrateddynamics.gametest.integration.ValueEntityMock;

public class TestEntityOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariableEntity eZombie;
    private DummyVariableEntity eZombieBurning;
    private DummyVariableEntity eZombieWet;
    private DummyVariableEntity eZombieCrouching;
    private DummyVariableEntity eZombieEating;
    private DummyVariableEntity eChicken;
    private DummyVariableEntity eItem;
    private DummyVariableEntity eItemFrame;
    private DummyVariableEntity ePlayer;
    private DummyVariableEntity eZombieHeldItems;
    private DummyVariableEntity eBoat;
    private DummyVariableEntity eItemframe;
    private DummyVariableEntity eZombieAged;
    private DummyVariableEntity eZombieBaby;
    private DummyVariableEntity eCow;
    private DummyVariableEntity eCowAlreadyBred;
    private DummyVariableEntity eCowBaby;
    private DummyVariableEntity eCowInLove;
    private DummyVariableEntity ePig;
    private DummyVariableEntity eSheep;
    private DummyVariableEntity eSheepSheared;
    private DummyVariableItemStack iCarrot;
    private DummyVariableItemStack iWheat;

    protected ValueObjectTypeEntity.ValueEntity makeEntity(Entity entity) {
        return new ValueEntityMock(entity);
    }

    @IntegrationBefore
    public void before() {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD);
        this.eZombie = new DummyVariableEntity(this.makeEntity((Entity)new Zombie(this, (Level)world){

            public boolean isInWaterOrRain() {
                return false;
            }
        }));
        Zombie zombieBurning = new Zombie((Level)world);
        zombieBurning.setRemainingFireTicks(10);
        this.eZombieBurning = new DummyVariableEntity(this.makeEntity((Entity)zombieBurning));
        Zombie zombieWet = new Zombie(this, (Level)world){

            protected void registerGoals() {
                super.registerGoals();
                this.wasTouchingWater = true;
            }
        };
        this.eZombieWet = new DummyVariableEntity(this.makeEntity((Entity)zombieWet));
        Zombie zombieCrouching = new Zombie(this, (Level)world){

            public boolean isCrouching() {
                return true;
            }
        };
        this.eZombieCrouching = new DummyVariableEntity(this.makeEntity((Entity)zombieCrouching));
        Zombie zombieEating = new Zombie(this, (Level)world){

            public int getUseItemRemainingTicks() {
                return 1;
            }
        };
        this.eZombieEating = new DummyVariableEntity(this.makeEntity((Entity)zombieEating));
        this.eChicken = new DummyVariableEntity(this.makeEntity((Entity)new Chicken(EntityType.CHICKEN, (Level)world)));
        this.eItem = new DummyVariableEntity(this.makeEntity((Entity)new ItemEntity((Level)world, 0.0, 0.0, 0.0, ItemStack.EMPTY)));
        this.eItemFrame = new DummyVariableEntity(this.makeEntity((Entity)new ItemFrame((Level)world, new BlockPos(0, 0, 0), Direction.NORTH)));
        this.ePlayer = IModHelpers.get().getMinecraftHelpers().isClientSide() ? new DummyVariableEntity(this.makeEntity((Entity)world.players().get(0))) : new DummyVariableEntity(this.makeEntity((Entity)new ServerPlayer(ServerLifecycleHooks.getCurrentServer(), ServerLifecycleHooks.getCurrentServer().overworld(), new GameProfile(UUID.randomUUID(), "test"), ClientInformation.createDefault())));
        Zombie zombieHeldItems = new Zombie((Level)world);
        zombieHeldItems.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.APPLE));
        zombieHeldItems.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.POTATO));
        this.eZombieHeldItems = new DummyVariableEntity(this.makeEntity((Entity)zombieHeldItems));
        Boat boat = new Boat(EntityType.ACACIA_BOAT, (Level)world, () -> ItemStack.EMPTY.getItem());
        ((ValueObjectTypeEntity.ValueEntity)this.eZombie.getValue()).getRawValue().get().startRiding((Entity)boat, true);
        this.eBoat = new DummyVariableEntity(this.makeEntity((Entity)boat));
        ItemFrame itemframe = new ItemFrame((Level)world, new BlockPos(0, 0, 0), Direction.NORTH);
        itemframe.setItem(new ItemStack((ItemLike)Items.POTATO));
        itemframe.setRotation(3);
        this.eItemframe = new DummyVariableEntity(this.makeEntity((Entity)itemframe));
        Zombie zombieAged = new Zombie(this, (Level)world){

            public int getNoActionTime() {
                return 3;
            }
        };
        this.eZombieAged = new DummyVariableEntity(this.makeEntity((Entity)zombieAged));
        Zombie zombieBaby = new Zombie((Level)world);
        zombieBaby.setBaby(true);
        this.eZombieBaby = new DummyVariableEntity(this.makeEntity((Entity)zombieBaby));
        this.eCow = new DummyVariableEntity(this.makeEntity((Entity)new Cow(EntityType.COW, (Level)world)));
        this.eCowAlreadyBred = new DummyVariableEntity(this.makeEntity((Entity)new Cow(this, EntityType.COW, (Level)world){

            public int getAge() {
                return 10;
            }
        }));
        this.eCowBaby = new DummyVariableEntity(this.makeEntity((Entity)new Cow(this, EntityType.COW, (Level)world){

            public int getAge() {
                return -10;
            }
        }));
        this.eCowInLove = new DummyVariableEntity(this.makeEntity((Entity)new Cow(this, EntityType.COW, (Level)world){

            public boolean isInLove() {
                return true;
            }
        }));
        this.ePig = new DummyVariableEntity(this.makeEntity((Entity)new Pig(EntityType.PIG, (Level)world)));
        this.eSheep = new DummyVariableEntity(this.makeEntity((Entity)new Sheep(EntityType.SHEEP, (Level)world)));
        Sheep sheepSheared = new Sheep(EntityType.SHEEP, (Level)world);
        sheepSheared.setSheared(true);
        this.eSheepSheared = new DummyVariableEntity(this.makeEntity((Entity)sheepSheared));
        this.iCarrot = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.CARROT)));
        this.iWheat = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.WHEAT)));
    }

    @IntegrationTest
    public void testBlockIsMob() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISMOB.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), true, "isismob(zombie) = true");
        IValue res2 = Operators.OBJECT_ENTITY_ISMOB.evaluate(this.eChicken);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), false, "isismob(chicken) = false");
        IValue res3 = Operators.OBJECT_ENTITY_ISMOB.evaluate(this.eItem);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), false, "isismob(item) = false");
        IValue res4 = Operators.OBJECT_ENTITY_ISMOB.evaluate(this.eItemFrame);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), false, "isismob(itemframe) = false");
        IValue res5 = Operators.OBJECT_ENTITY_ISMOB.evaluate(this.ePlayer);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res5).getRawValue(), false, "isismob(player) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsMobLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISMOB.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsMobSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISMOB.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsMob() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISMOB.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsAnimal() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISANIMAL.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isisanimal(zombie) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISANIMAL.evaluate(this.eChicken);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isisanimal(chicken) = true");
        IValue res3 = Operators.OBJECT_ENTITY_ISANIMAL.evaluate(this.eItem);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), false, "isisanimal(item) = false");
        IValue res4 = Operators.OBJECT_ENTITY_ISANIMAL.evaluate(this.eItemFrame);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), false, "isisanimal(itemframe) = false");
        IValue res5 = Operators.OBJECT_ENTITY_ISANIMAL.evaluate(this.ePlayer);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res5).getRawValue(), false, "isismob(player) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsAnimalLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISANIMAL.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsAnimalSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISANIMAL.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsAnimal() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISANIMAL.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsItem() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISITEM.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isisitem(zombie) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISITEM.evaluate(this.eChicken);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), false, "isisitem(chicken) = false");
        IValue res3 = Operators.OBJECT_ENTITY_ISITEM.evaluate(this.eItem);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), true, "isisitem(item) = true");
        IValue res4 = Operators.OBJECT_ENTITY_ISITEM.evaluate(this.eItemFrame);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), false, "isisitem(itemframe) = false");
        IValue res5 = Operators.OBJECT_ENTITY_ISITEM.evaluate(this.ePlayer);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res5).getRawValue(), false, "isismob(player) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsItemLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISITEM.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsItemSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISITEM.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsItem() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISITEM.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsPlayer() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISPLAYER.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isisplayer(zombie) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISPLAYER.evaluate(this.eChicken);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), false, "isisplayer(chicken) = false");
        IValue res3 = Operators.OBJECT_ENTITY_ISPLAYER.evaluate(this.eItem);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), false, "isisplayer(item) = false");
        IValue res4 = Operators.OBJECT_ENTITY_ISPLAYER.evaluate(this.eItemFrame);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), false, "isisplayer(itemframe) = false");
        IValue res5 = Operators.OBJECT_ENTITY_ISPLAYER.evaluate(this.ePlayer);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res5).getRawValue(), true, "isisplayer(player) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsPlayerLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISPLAYER.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsPlayerSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISPLAYER.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsPlayer() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISPLAYER.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockItemStack() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ITEMSTACK.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is an itemstack");
        TestHelpers.assertEqual(!((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue().isEmpty(), false, "itemstack(zombie) = null");
        IValue res2 = Operators.OBJECT_ENTITY_ITEMSTACK.evaluate(this.eItem);
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res2).getRawValue().isEmpty(), true, "itemstack(null) = null");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemStackLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ITEMSTACK.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemStackSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ITEMSTACK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeItemStack() throws EvaluationException {
        Operators.OBJECT_ENTITY_ITEMSTACK.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockHealth() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_HEALTH.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeDouble.ValueDouble, "result is a double");
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res1).getRawValue(), 20.0, "health(zombie) = 10");
        IValue res2 = Operators.OBJECT_ENTITY_HEALTH.evaluate(this.eItem);
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res2).getRawValue(), 0.0, "health(item) = 0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHealthLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_HEALTH.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHealthSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_HEALTH.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeHealth() throws EvaluationException {
        Operators.OBJECT_ENTITY_HEALTH.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockWidth() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_WIDTH.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeDouble.ValueDouble, "result is a double");
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res1).getRawValue(), 0.6, "width(zombie) = 0.6");
        IValue res2 = Operators.OBJECT_ENTITY_WIDTH.evaluate(this.eItem);
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res2).getRawValue(), 0.25, "width(item) = 0.25");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeWidthLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_WIDTH.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeWidthSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_WIDTH.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeWidth() throws EvaluationException {
        Operators.OBJECT_ENTITY_WIDTH.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockHeight() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_HEIGHT.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeDouble.ValueDouble, "result is a double");
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res1).getRawValue(), 2.0, "height(zombie) = 2");
        IValue res2 = Operators.OBJECT_ENTITY_HEIGHT.evaluate(this.eItem);
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res2).getRawValue(), 0.25, "height(item) = 0.25");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHeightLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_HEIGHT.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHeightSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_HEIGHT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeHeight() throws EvaluationException {
        Operators.OBJECT_ENTITY_HEIGHT.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsBurning() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISBURNING.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isburning(zombie) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISBURNING.evaluate(this.eZombieBurning);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isburning(zombie:burning) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsBurningLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISBURNING.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsBurningSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISBURNING.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsBurning() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISBURNING.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsWet() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISWET.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "iswet(zombie) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISWET.evaluate(this.eZombieWet);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "iswet(zombie:wet) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsWetLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISWET.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsWetSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISWET.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsWet() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISWET.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsCrouching() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISCROUCHING.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "issneaking(zombie) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISCROUCHING.evaluate(this.eZombieCrouching);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "issneaking(zombie:sneaking) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsCrouchingLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISCROUCHING.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsCrouchingSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISCROUCHING.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsCrouching() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISCROUCHING.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsEating() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISEATING.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "iseating(zombie) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISEATING.evaluate(this.eZombieEating);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "iseating(zombie:eating) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsEatingLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISEATING.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsEatingSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISEATING.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsEating() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISEATING.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityModName() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_MODNAME.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), "Minecraft", "modname(zombie) = Minecraft");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModNameLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_MODNAME.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModNameSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_MODNAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeModName() throws EvaluationException {
        Operators.OBJECT_ENTITY_MODNAME.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityHeldItemMain() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_HELDITEM_MAIN.evaluate(this.eZombieHeldItems);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is an item");
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue().getItem(), Items.APPLE, "helditemmain(zombie) = apple");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHeldItemMainLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_HELDITEM_MAIN.evaluate(this.eZombieHeldItems, this.eZombieHeldItems);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHeldItemMainSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_HELDITEM_MAIN.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeHeldItemMain() throws EvaluationException {
        Operators.OBJECT_ENTITY_HELDITEM_MAIN.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityHeldItemOff() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_HELDITEM_OFF.evaluate(this.eZombieHeldItems);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is an item");
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue().getItem(), Items.POTATO, "helditemoff(zombie) = potato");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHeldItemOffLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_HELDITEM_OFF.evaluate(this.eZombieHeldItems, this.eZombieHeldItems);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHeldItemOffSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_HELDITEM_OFF.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeHeldItemOff() throws EvaluationException {
        Operators.OBJECT_ENTITY_HELDITEM_OFF.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityMounted() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_MOUNTED.evaluate(this.eBoat);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), 1, "#mounted(boat) = 1");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeMountedLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_MOUNTED.evaluate(this.eBoat, this.eBoat);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeMountedSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_MOUNTED.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeMounted() throws EvaluationException {
        Operators.OBJECT_ENTITY_MOUNTED.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityItemframeContents() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMFRAME_CONTENTS.evaluate(this.eItemframe);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is an item");
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue().getItem(), Items.POTATO, "itemframecontents(itemframe) = potato");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemframeContentsLarge() throws EvaluationException {
        Operators.OBJECT_ITEMFRAME_CONTENTS.evaluate(this.eItemframe, this.eItemframe);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemframeContentsSmall() throws EvaluationException {
        Operators.OBJECT_ITEMFRAME_CONTENTS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeItemframeContents() throws EvaluationException {
        Operators.OBJECT_ITEMFRAME_CONTENTS.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityItemframeRotation() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMFRAME_ROTATION.evaluate(this.eItemframe);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 3, "itemframerotation(itemframe) = 3");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemframeRotationLarge() throws EvaluationException {
        Operators.OBJECT_ITEMFRAME_ROTATION.evaluate(this.eItemframe, this.eItemframe);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemframeRotationSmall() throws EvaluationException {
        Operators.OBJECT_ITEMFRAME_ROTATION.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeItemframeRotation() throws EvaluationException {
        Operators.OBJECT_ITEMFRAME_ROTATION.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityHurtSound() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_HURTSOUND.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), "minecraft:entity.zombie.hurt", "hurtsound(zomie) = minecraft:entity.zombie.hurt");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHurtSoundLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_HURTSOUND.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHurtSoundSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_HURTSOUND.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeHurtSound() throws EvaluationException {
        Operators.OBJECT_ENTITY_HURTSOUND.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityDeathSound() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_DEATHSOUND.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), "minecraft:entity.zombie.death", "deathsound(zomie) = minecraft:entity.zombie.death");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeDeathSoundLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_DEATHSOUND.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeDeathSoundSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_DEATHSOUND.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeDeathSound() throws EvaluationException {
        Operators.OBJECT_ENTITY_DEATHSOUND.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockAge() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_AGE.evaluate(this.eZombieAged);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 3, "age(zombie) = 3");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeAgeLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_AGE.evaluate(this.eZombieAged, this.eZombieAged);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeAgeSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_AGE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeAge() throws EvaluationException {
        Operators.OBJECT_ENTITY_AGE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsChild() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISCHILD.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "ischild(zombie) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISCHILD.evaluate(this.eZombieBaby);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "ischild(zombie) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsChildLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISCHILD.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsChildSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISCHILD.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsChild() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISCHILD.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockCanBreed() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_CANBREED.evaluate(this.eCow);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), true, "canbreed(cow) = true");
        IValue res2 = Operators.OBJECT_ENTITY_CANBREED.evaluate(this.eCowAlreadyBred);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), false, "canbreed(cowbred) = false");
        IValue res3 = Operators.OBJECT_ENTITY_CANBREED.evaluate(this.eCowBaby);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), false, "canbreed(cowbaby) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeCanBreedLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_CANBREED.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeCanBreedSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_CANBREED.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeCanBreed() throws EvaluationException {
        Operators.OBJECT_ENTITY_CANBREED.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsInLove() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISINLOVE.evaluate(this.eCow);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isinlove(cow) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISINLOVE.evaluate(this.eCowInLove);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isinlove(cowloving) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsInLoveLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISINLOVE.evaluate(this.eCow, this.eCow);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsInLoveSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISINLOVE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsInLove() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISINLOVE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockCanBreedWith() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_CANBREEDWITH.evaluate(this.eCow, this.iCarrot);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "canbreedwith(cow, carrot) = false");
        IValue res2 = Operators.OBJECT_ENTITY_CANBREEDWITH.evaluate(this.eCow, this.iWheat);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "canbreedwith(cow, wheat) = true");
        IValue res3 = Operators.OBJECT_ENTITY_CANBREEDWITH.evaluate(this.ePig, this.iCarrot);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), true, "canbreedwith(pig, carrot) = true");
        IValue res4 = Operators.OBJECT_ENTITY_CANBREEDWITH.evaluate(this.ePig, this.iWheat);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), false, "canbreedwith(pig, wheat) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeCanBreedWithLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_CANBREEDWITH.evaluate(this.eCow, this.iCarrot, this.iCarrot);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeCanBreedWithSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_CANBREEDWITH.evaluate(this.eCow);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeCanBreedWith() throws EvaluationException {
        Operators.OBJECT_ENTITY_CANBREEDWITH.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsShearable() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_ISSHEARABLE.evaluate(this.eCow);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isshearable(cow) = false");
        IValue res2 = Operators.OBJECT_ENTITY_ISSHEARABLE.evaluate(this.eSheep);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isshearable(sheep) = true");
        IValue res3 = Operators.OBJECT_ENTITY_ISSHEARABLE.evaluate(this.eSheepSheared);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), false, "isshearable(sheepsheared) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsShearableLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISSHEARABLE.evaluate(this.eCow, this.eCow);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsShearableSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISSHEARABLE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsShearable() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISSHEARABLE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockNbt() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_NBT.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeNbt.ValueNbt, "result is an nbt tag");
        TestHelpers.assertNonEqual(((ValueTypeNbt.ValueNbt)res1).getRawValue(), new CompoundTag(), "isnbt(zombie) is not null");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeNbtLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_NBT.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeNbtSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_NBT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeNbt() throws EvaluationException {
        Operators.OBJECT_ENTITY_NBT.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testEntityType() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ENTITY_TYPE.evaluate(this.eZombie);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), "minecraft:zombie", "entitytype(zombie) = minecraft:zombie");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTypeLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_TYPE.evaluate(this.eZombie, this.eZombie);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTypeSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_TYPE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeType() throws EvaluationException {
        Operators.OBJECT_ENTITY_TYPE.evaluate(DUMMY_VARIABLE);
    }
}

