/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;

public class ItemEnhancement
extends Item {
    private final Type type;

    public ItemEnhancement(Type type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public <P extends IPartType<P, S>, S extends IPartState<P>> InteractionResult applyEnhancement(IPartType<P, S> partType, IPartState<P> partState, ItemStack itemStack, Player player, InteractionHand hand) {
        switch (this.type.ordinal()) {
            case 0: {
                if (!partType.supportsOffsets()) break;
                int value = this.getEnhancementValue(itemStack);
                int newValue = partState.getMaxOffset() + value;
                if (newValue <= GeneralConfig.maxPartOffset) {
                    if (!player.level().isClientSide()) {
                        partState.setMaxOffset(newValue);
                        itemStack.shrink(1);
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.enhancement_offset.increased", (Object[])new Object[]{newValue}), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.enhancement_offset.limit", (Object[])new Object[]{GeneralConfig.maxPartOffset}), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public int getEnhancementValue(ItemStack itemStack) {
        return Objects.requireNonNullElse((Integer)itemStack.get(RegistryEntries.DATACOMPONENT_PART_ENHANCEMENT), 0);
    }

    public void setEnhancementValue(ItemStack itemStack, int value) {
        itemStack.set(RegistryEntries.DATACOMPONENT_PART_ENHANCEMENT, (Object)value);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)"item.integrateddynamics.enhancement_offset.tooltip", (Object[])new Object[]{this.getEnhancementValue(itemStack)}).withStyle(ChatFormatting.GRAY));
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
    }

    public static enum Type {
        OFFSET;

    }
}

