/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPatternCommon;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerSetElementInventory;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeIngredientsValueChangedPacket;

public class ValueTypeIngredientsLPElement
extends ValueTypeLPElementBase {
    protected static final int OFFSET_X = 20;
    protected static final int OFFSET_Y = 21;
    private IngredientComponent currentType = IngredientComponent.ITEMSTACK;
    private Map<IngredientComponent, Integer> lengths = Maps.newHashMap();
    private Map<IngredientComponent, Map<Integer, IValueTypeLogicProgrammerElement>> subElements = Maps.newHashMap();
    private Map<IngredientComponent, Map<Integer, RenderPattern>> subElementGuis = Maps.newHashMap();
    private int activeElement = -1;
    @OnlyIn(value=Dist.CLIENT)
    private MasterSubGuiRenderPattern masterGui;
    private ValueObjectTypeIngredients.ValueIngredients serverValue = null;

    public ValueTypeIngredientsLPElement() {
        super(ValueTypes.OBJECT_INGREDIENTS);
    }

    public void setServerValue(ValueObjectTypeIngredients.ValueIngredients serverValue) {
        this.serverValue = serverValue;
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE_CANVAS_WIDE;
    }

    @Override
    public boolean canWriteElementPre() {
        return true;
    }

    protected IMixedIngredients constructValues() {
        IdentityHashMap lists = Maps.newIdentityHashMap();
        for (IngredientComponent<?, ?> component : IngredientComponentHandlers.REGISTRY.getComponents()) {
            ArrayList values = Lists.newArrayListWithExpectedSize((int)this.lengths.get(component));
            this.subElements.get(component).entrySet().forEach(entry -> {
                IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                try {
                    values.add(componentHandler.toInstance(((IValueTypeLogicProgrammerElement)entry.getValue()).getValue()));
                }
                catch (Exception e) {
                    values.add(component.getMatcher().getEmptyInstance());
                }
            });
            if (values.isEmpty()) continue;
            lists.put(component, values);
        }
        return new MixedIngredients((Map)lists);
    }

    @Override
    public IValue getValue() {
        return MinecraftHelpers.isClientSideThread() ? ValueObjectTypeIngredients.ValueIngredients.of(this.constructValues()) : this.serverValue;
    }

    @Override
    public void setValue(IValue value) {
        ValueObjectTypeIngredients.ValueIngredients valueIngredients = (ValueObjectTypeIngredients.ValueIngredients)value;
        if (!MinecraftHelpers.isClientSideThread()) {
            this.setServerValue(valueIngredients);
        }
        valueIngredients.getRawValue().ifPresent(ingredients -> {
            this.currentType = ingredients.getComponents().contains(IngredientComponent.ITEMSTACK) ? IngredientComponent.ITEMSTACK : null;
            for (IngredientComponent ingredientComponent : ingredients.getComponents()) {
                IIngredientComponentHandler handler = IngredientComponentHandlers.REGISTRY.getComponentHandler(ingredientComponent);
                if (this.currentType == null) {
                    this.currentType = ingredientComponent;
                }
                this.lengths.put(ingredientComponent, ingredients.getInstances(ingredientComponent).size());
                HashMap entries = Maps.newHashMap();
                List instances = ingredients.getInstances(ingredientComponent);
                for (int i = 0; i < instances.size(); ++i) {
                    this.initializeElementFromInstanceValue(entries, handler, instances.get(i), i);
                }
                this.subElements.put(ingredientComponent, entries);
            }
        });
    }

    protected <VT extends IValueType<V>, V extends IValue, T, M> void initializeElementFromInstanceValue(Map<Integer, IValueTypeLogicProgrammerElement> entries, IIngredientComponentHandler<VT, V, T, M> handler, T instance, int instanceIndex) {
        V instanceValue = handler.toValue(instance);
        IValueTypeLogicProgrammerElement lpElement = instanceValue.getType().createLogicProgrammerElement();
        lpElement.setValue((IValue)instanceValue);
        entries.put(instanceIndex, lpElement);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setValueInGui(ISubGuiBox subGui) {
        if (!this.subElements.get(this.currentType).isEmpty()) {
            this.setActiveElement(0);
        }
    }

    @Override
    public void setValueInContainer(ContainerLogicProgrammerBase container) {
        if (!this.subElements.get(this.currentType).isEmpty()) {
            IValueTypeLogicProgrammerElement subElement = this.setActiveElement(0);
            int x = RenderPatternCommon.calculateX(88, 160, subElement.getRenderPattern()) + 88 - 20;
            int y = RenderPatternCommon.calculateY(18, 87, subElement.getRenderPattern()) + 18 - 21;
            container.setElementInventory(subElement, x, y);
            subElement.setValueInContainer(container);
        }
    }

    public int getLength() {
        return this.lengths.get(this.currentType);
    }

    public void setLength(int length) {
        this.lengths.put(this.currentType, length);
        this.setActiveElement(this.getLength() - 1);
    }

    public void setCurrentType(IngredientComponent currentType) {
        this.currentType = currentType;
        this.setActiveElement(this.subElements.get(currentType).size() - 1);
    }

    public IValueTypeLogicProgrammerElement setActiveElement(int index) {
        this.activeElement = index;
        IValueTypeLogicProgrammerElement subElement = null;
        if (index >= 0) {
            if (!this.subElements.get(this.currentType).containsKey(index)) {
                subElement = IngredientComponentHandlers.REGISTRY.getComponentHandler(this.currentType).getValueType().createLogicProgrammerElement();
                this.subElements.get(this.currentType).put(index, subElement);
            } else {
                subElement = this.subElements.get(this.currentType).get(index);
            }
        }
        if (MinecraftHelpers.isClientSideThread() && this.masterGui != null) {
            this.masterGui.setActiveElement(this.activeElement);
            this.masterGui.container.onDirty();
        }
        return subElement;
    }

    public void removeElement(int index) {
        Map<Integer, IValueTypeLogicProgrammerElement> oldSubElements = this.subElements.get(this.currentType);
        Map<Integer, RenderPattern> oldSubElementGuis = this.subElementGuis.get(this.currentType);
        this.subElements.put(this.currentType, Maps.newHashMap());
        this.subElementGuis.put(this.currentType, Maps.newHashMap());
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : oldSubElements.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElements.get(this.currentType).put(i, entry.getValue());
                this.subElementGuis.get(this.currentType).put(i, oldSubElementGuis.get(i));
                continue;
            }
            if (i <= index) continue;
            this.subElements.get(this.currentType).put(i - 1, entry.getValue());
            this.subElementGuis.get(this.currentType).put(i - 1, oldSubElementGuis.get(i));
        }
        this.setLength(this.getLength() - 1);
    }

    @Override
    public void activate() {
        for (IngredientComponent<?, ?> recipeComponent : IngredientComponentHandlers.REGISTRY.getComponents()) {
            this.subElements.put(recipeComponent, Maps.newHashMap());
            this.subElementGuis.put(recipeComponent, Maps.newHashMap());
            this.lengths.put(recipeComponent, 0);
        }
    }

    @Override
    public void deactivate() {
    }

    @Override
    public Component validate() {
        if (!MinecraftHelpers.isClientSideThread()) {
            return this.serverValue == null ? Component.literal((String)"") : null;
        }
        if (MinecraftHelpers.isClientSideThread()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeIngredientsValueChangedPacket(ValueDeseralizationContext.ofClient(), ValueObjectTypeIngredients.ValueIngredients.of(this.constructValues())));
        }
        for (Map<Integer, IValueTypeLogicProgrammerElement> componentValues : this.subElements.values()) {
            for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : componentValues.entrySet()) {
                Component error = entry.getValue().validate();
                if (error == null) continue;
                return Component.translatable((String)"valuetype.integrateddynamics.error.invalid_list_element", (Object[])new Object[]{entry.getKey(), error});
            }
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return slotId == 0 && super.isItemValidForSlot(slotId, itemStack) || this.activeElement >= 0 && this.subElements.get(this.currentType).containsKey(this.activeElement) && this.subElements.get(this.currentType).get(this.activeElement).isItemValidForSlot(slotId, itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.masterGui = new MasterSubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.masterGui;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class MasterSubGuiRenderPattern
    extends RenderPattern<ValueTypeIngredientsLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IRenderPatternValueTypeTooltip {
        private final int baseX;
        private final int baseY;
        private final int maxWidth;
        private final int maxHeight;
        private final ContainerScreenLogicProgrammerBase gui;
        private final ContainerLogicProgrammerBase container;
        protected ListElementSubGui elementSubGui = null;
        protected int lastGuiLeft;
        protected int lastGuiTop;
        private boolean renderTooltip = true;

        public MasterSubGuiRenderPattern(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGuiHolder.addSubGui(new SelectionSubGui(element, baseX, baseY, maxWidth, maxHeight, gui, container));
            this.baseX = baseX;
            this.baseY = baseY;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.gui = gui;
            this.container = container;
        }

        public void setActiveElement(int index) {
            if (this.elementSubGui != null) {
                this.subGuiHolder.removeSubGui(this.elementSubGui);
                ((ContainerLogicProgrammerBase)this.gui.getMenu()).setElementInventory(null, 0, 0);
            }
            if (index >= 0) {
                this.elementSubGui = new ListElementSubGui((ValueTypeIngredientsLPElement)this.element, this.baseX, this.baseY + this.getHeight() / 4, this.maxWidth, this.maxHeight, this.gui, this.container);
                this.subGuiHolder.addSubGui(this.elementSubGui);
                this.elementSubGui.init(this.lastGuiLeft, this.lastGuiTop);
            }
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }

        @Override
        public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            this.drawTooltipForeground(this.gui, guiGraphics, this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeIngredientsLPElement)this.element).getValueType());
        }

        @Override
        public boolean isRenderTooltip() {
            return this.renderTooltip;
        }

        @Override
        public void setRenderTooltip(boolean renderTooltip) {
            this.renderTooltip = renderTooltip;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class ListElementSubGui
    extends RenderPattern<ValueTypeIngredientsLPElement, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> {
        private ButtonArrow arrowLeft;
        private ButtonArrow arrowRight;
        private Button arrowRemove;
        private RenderPattern subGui;
        private IValueTypeLogicProgrammerElement subElement;

        public ListElementSubGui(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase<?> gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGui = element.subElementGuis.get(element.currentType).get(element.activeElement);
            this.subElement = element.subElements.get(element.currentType).get(element.activeElement);
            if (this.subGui == null) {
                this.subGui = (RenderPattern)this.subElement.createSubGui(baseX, baseY, maxWidth, maxHeight / 3 * 2, gui, container);
                element.subElementGuis.get(element.currentType).put(element.activeElement, this.subGui);
            }
            int x = this.getX() + baseX - 20;
            int y = this.getY() + baseY - 21;
            ((ContainerLogicProgrammerBase)gui.getMenu()).setElementInventory(this.subElement, x, y);
            this.subGuiHolder.addSubGui(this.subGui);
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerSetElementInventory((IValueType)IngredientComponentHandlers.REGISTRY.getComponentHandler(element.currentType).getValueType(), x, y));
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4 * 3;
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowLeft = new ButtonArrow(x, y, (Component)Component.translatable((String)"gui.cyclopscore.left"), b -> ((ValueTypeIngredientsLPElement)this.element).setActiveElement(((ValueTypeIngredientsLPElement)this.element).activeElement - 1), ButtonArrow.Direction.WEST);
            this.buttonList.add(this.arrowLeft);
            this.arrowRight = new ButtonArrow(x + this.getWidth() - this.arrowLeft.getWidth() - 1, y, (Component)Component.translatable((String)"gui.cyclopscore.right"), b -> ((ValueTypeIngredientsLPElement)this.element).setActiveElement(((ValueTypeIngredientsLPElement)this.element).activeElement + 1), ButtonArrow.Direction.EAST);
            this.buttonList.add(this.arrowRight);
            this.arrowRemove = new ButtonText(x + this.getWidth() / 2 - this.arrowLeft.getWidth() / 2, y + this.getHeight() - 13, 12, 12, (Component)Component.translatable((String)"gui.integrateddynamics.button.remove"), (Component)Component.literal((String)"-"), b -> ((ValueTypeIngredientsLPElement)this.element).removeElement(((ValueTypeIngredientsLPElement)this.element).activeElement), true);
            this.buttonList.add(this.arrowRemove);
            this.arrowLeft.active = ((ValueTypeIngredientsLPElement)this.element).activeElement > 0;
            this.arrowRight.active = ((ValueTypeIngredientsLPElement)this.element).activeElement < ((ValueTypeIngredientsLPElement)this.element).getLength() - 1;
            this.arrowRemove.active = ((ValueTypeIngredientsLPElement)this.element).getLength() > 0;
            this.subElement.setValueInGui(this.subGui);
            this.subElement.setValueInContainer(this.subGui.container);
        }

        @Override
        public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            int x = guiLeft + this.getX() + this.getWidth() / 2;
            int y = guiTop + this.getY() + 4;
            RenderHelpers.drawScaledCenteredString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)fontRenderer, (String)String.valueOf(((ValueTypeIngredientsLPElement)this.element).activeElement), (int)(x - 4), (int)(y + 2), (int)10, (int)Helpers.RGBToInt((int)20, (int)20, (int)20), (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class SelectionSubGui
    extends RenderPattern<ValueTypeIngredientsLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IInputListener {
        private WidgetArrowedListField<IngredientComponent<?, ?>> valueTypeSelector = null;
        private Button arrowAdd;

        public SelectionSubGui(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4;
        }

        protected static List<IngredientComponent<?, ?>> getValueTypes() {
            return IngredientComponentHandlers.REGISTRY.getComponents().stream().sorted(Comparator.comparing(IngredientComponent::getName).reversed()).toList();
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.valueTypeSelector = new WidgetArrowedListField<IngredientComponent<?, ?>>(this, Minecraft.getInstance().font, this.getX() + guiLeft + this.getWidth() / 2 - 50, this.getY() + guiTop + 2, 100, 15, true, (Component)Component.translatable((String)"valuetype.integrateddynamics.value_type"), true, SelectionSubGui.getValueTypes()){

                protected String activeElementToString(IngredientComponent element) {
                    return L10NHelpers.localize((String)element.getTranslationKey(), (Object[])new Object[0]);
                }
            };
            this.valueTypeSelector.setListener((IInputListener)this);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowAdd = new ButtonText(x + this.getWidth() - 13, y + this.getHeight() - 13, 12, 12, (Component)Component.translatable((String)"gui.integrateddynamics.button.add"), (Component)Component.literal((String)"+"), b -> {}, true);
            this.buttonList.add(this.arrowAdd);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            return super.mouseClicked(mouseX, mouseY, mouseButton) || this.valueTypeSelector.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void actionPerformed(Button guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowAdd) {
                ((ValueTypeIngredientsLPElement)this.element).setLength(((ValueTypeIngredientsLPElement)this.element).getLength() + 1);
            }
        }

        @Override
        public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.valueTypeSelector.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public void onChanged() {
            ((ValueTypeIngredientsLPElement)this.element).setCurrentType((IngredientComponent)this.valueTypeSelector.getActiveElement());
        }
    }
}

