/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElementValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeString;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerAspectSettings;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;

public class ContainerScreenAspectSettings
extends ContainerScreenExtended<ContainerAspectSettings> {
    private static final int ERROR_WIDTH = 13;
    private static final int ERROR_HEIGHT = 13;
    private static final int OK_WIDTH = 14;
    private static final int OK_HEIGHT = 12;
    private final List<IAspectPropertyTypeInstance> propertyTypes;
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();
    protected IGuiInputElementValueType<RenderPattern, ContainerScreenAspectSettings, ContainerAspectSettings> guiElement = null;
    protected int activePropertyIndex = 0;
    protected RenderPattern propertyConfigPattern = null;
    protected SubGuiValueTypeInfo propertyInfo = null;
    private ButtonText buttonLeft = null;
    private ButtonText buttonRight = null;
    private ButtonText buttonExit = null;
    private Component lastError;

    public ContainerScreenAspectSettings(ContainerAspectSettings container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.propertyTypes = Lists.newArrayList(container.getAspect().getDefaultProperties().getTypes());
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"textures/gui/aspect_settings.png");
    }

    public int getActivePropertyIndex() {
        return this.activePropertyIndex;
    }

    protected void saveSetting() {
        if (this.guiElement != null && this.lastError == null) {
            ((ContainerAspectSettings)this.container).setValue(ValueDeseralizationContext.ofClient(), this.getActiveProperty(), this.guiElement.getValue());
        }
    }

    protected void refreshButtonEnabled() {
        this.buttonLeft.active = this.getActivePropertyIndex() > 0;
        this.buttonRight.active = this.getActivePropertyIndex() < this.propertyTypes.size() - 1;
    }

    protected int getBaseYSize() {
        return 213;
    }

    public void init() {
        super.init();
        this.subGuiHolder.init(this.leftPos, this.topPos);
        this.buttonExit = new ButtonText(this.leftPos + 7, this.topPos + 5, 12, 10, (Component)Component.translatable((String)"gui.cyclopscore.up"), (Component)Component.literal((String)"<<"), this.createServerPressable("button_exit", button -> this.saveSetting()), true);
        this.addRenderableWidget((GuiEventListener)this.buttonExit);
        this.buttonLeft = new ButtonText(this.leftPos + 21, this.topPos + 5, 10, 10, (Component)Component.translatable((String)"gui.cyclopscore.left"), (Component)Component.literal((String)"<"), button -> {
            this.saveSetting();
            if (this.getActivePropertyIndex() > 0) {
                this.setActiveProperty(this.getActivePropertyIndex() - 1);
                this.refreshButtonEnabled();
            }
        }, true);
        this.addRenderableWidget((GuiEventListener)this.buttonLeft);
        this.buttonRight = new ButtonText(this.leftPos + 159, this.topPos + 5, 10, 10, (Component)Component.translatable((String)"gui.cyclopscore.right"), (Component)Component.literal((String)">"), button -> {
            this.saveSetting();
            if (this.getActivePropertyIndex() < this.propertyTypes.size()) {
                this.setActiveProperty(this.getActivePropertyIndex() + 1);
                this.refreshButtonEnabled();
            }
        }, true);
        this.addRenderableWidget((GuiEventListener)this.buttonRight);
        this.refreshButtonEnabled();
        this.setActiveProperty(this.activePropertyIndex);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.subGuiHolder.renderBg(guiGraphics, this.leftPos, this.topPos, this.getMinecraft().getTextureManager(), this.font, partialTicks, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.subGuiHolder.drawGuiContainerForegroundLayer(guiGraphics, this.leftPos, this.topPos, this.getMinecraft().getTextureManager(), this.font, mouseX, mouseY);
        IAspectPropertyTypeInstance activeProperty = this.getActiveProperty();
        if (activeProperty != null) {
            String unlocalizedInfo;
            String label = L10NHelpers.localize((String)activeProperty.getTranslationKey(), (Object[])new Object[0]);
            RenderHelpers.drawScaledCenteredString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)this.font, (String)label, (int)88, (int)10, (int)0, (float)1.0f, (int)140, (int)Helpers.RGBToInt((int)10, (int)10, (int)10), (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
            if (RenderHelpers.isPointInRegion((int)(this.leftPos + 40), (int)this.topPos, (int)110, (int)20, (double)mouseX, (double)mouseY) && I18n.exists((String)(unlocalizedInfo = activeProperty.getTranslationKey() + ".info"))) {
                this.drawTooltip(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)unlocalizedInfo).withStyle(ChatFormatting.GRAY)}), guiGraphics.pose(), mouseX - this.leftPos, mouseY - this.topPos + 20);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.subGuiHolder.charTyped(typedChar, keyCode)) {
            if (keyCode != 1 && this.getMinecraft().options.keyInventory.getKey().getValue() != keyCode) return super.charTyped(typedChar, keyCode);
            this.saveSetting();
            this.getMinecraft().player.closeContainer();
            return false;
        } else {
            if (this.guiElement == null) return false;
            this.onValueChanged();
        }
        return false;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.subGuiHolder.keyPressed(typedChar, keyCode, modifiers)) {
                if (this.guiElement != null) {
                    this.onValueChanged();
                }
                return true;
            }
            return false;
        }
        this.saveSetting();
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void onValueChanged() {
        this.lastError = this.guiElement.validate();
    }

    protected IAspectPropertyTypeInstance getActiveProperty() {
        return this.propertyTypes.get(Math.max(0, Math.min(this.propertyTypes.size() - 1, this.activePropertyIndex)));
    }

    protected void setActiveProperty(int index) {
        this.activePropertyIndex = index;
        this.onActivateElement(this.propertyTypes.get(this.activePropertyIndex));
    }

    protected void onActivateElement(IAspectPropertyTypeInstance property) {
        if (this.guiElement != null) {
            this.guiElement.deactivate();
            this.subGuiHolder.removeSubGui(this.propertyConfigPattern);
            this.subGuiHolder.removeSubGui(this.propertyInfo);
        }
        IValueTypeLogicProgrammerElement lpElement = property.getType().createLogicProgrammerElement();
        this.guiElement = lpElement.createInnerGuiElement();
        if (this.guiElement == null) {
            throw new UnsupportedOperationException("Tried to invoke createInnerGuiElement on a value type that does not have an inner gui element: " + property.getType().getTypeName());
        }
        this.guiElement.setValidator(property.getValidator());
        this.propertyConfigPattern = (RenderPattern)this.guiElement.createSubGui(8, 17, 160, 91, this, (ContainerAspectSettings)this.getMenu());
        this.subGuiHolder.addSubGui(this.propertyConfigPattern);
        this.propertyInfo = new SubGuiValueTypeInfo(this.guiElement);
        this.subGuiHolder.addSubGui(this.propertyInfo);
        this.propertyConfigPattern.init(this.leftPos, this.topPos);
        this.guiElement.activate();
        this.syncInputValue();
        this.lastError = this.guiElement.validate();
    }

    protected void syncInputValue() {
        IAspectPropertyTypeInstance property = this.getActiveProperty();
        Object value = ((ContainerAspectSettings)this.container).getPropertyValue(ValueDeseralizationContext.of(Minecraft.getInstance().player.level()), property);
        if (value != null) {
            this.guiElement.setValue((IValue)value);
            this.guiElement.setValueInGui(this.propertyConfigPattern, false);
        }
        this.onValueChanged();
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        IAspectPropertyTypeInstance property = (IAspectPropertyTypeInstance)((ContainerAspectSettings)this.container).getPropertyIds().get((Object)valueId);
        if (property != null && this.getActiveProperty() == property) {
            this.syncInputValue();
        }
    }

    public class SubGuiValueTypeInfo
    extends GuiElementValueTypeString.SubGuiValueTypeInfo<RenderPattern, ContainerScreenAspectSettings, ContainerAspectSettings> {
        public SubGuiValueTypeInfo(IGuiInputElement<RenderPattern, ContainerScreenAspectSettings, ContainerAspectSettings> element) {
            super(ContainerScreenAspectSettings.this, (ContainerAspectSettings)ContainerScreenAspectSettings.this.container, element, 8, 105, 160, 20);
        }

        @Override
        protected boolean showError() {
            return true;
        }

        @Override
        protected Component getLastError() {
            return ContainerScreenAspectSettings.this.lastError;
        }

        @Override
        protected ResourceLocation getTexture() {
            return ContainerScreenAspectSettings.this.texture;
        }
    }
}

