/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class EnergyHelpers {
    private static final List<IEnergyStorageProxy> ENERGY_STORAGE_PROXIES = Lists.newArrayList();

    public static void addEnergyStorageProxy(IEnergyStorageProxy energyStorageProxy) {
        ENERGY_STORAGE_PROXIES.add(energyStorageProxy);
    }

    public static Optional<IEnergyStorage> getEnergyStorage(PartPos pos) {
        return EnergyHelpers.getEnergyStorage(pos.getPos(), pos.getSide());
    }

    public static Optional<IEnergyStorage> getEnergyStorage(DimPos pos, Direction facing) {
        Level world = pos.getLevel(true);
        return world != null ? EnergyHelpers.getEnergyStorage(world, pos.getBlockPos(), facing) : Optional.empty();
    }

    public static Optional<IEnergyStorage> getEnergyStorage(Level world, BlockPos pos, Direction facing) {
        IEnergyStorage energyStorage = BlockEntityHelpers.getCapability((ILevelExtension)world, (BlockPos)pos, (Object)facing, (BlockCapability)Capabilities.EnergyStorage.BLOCK).orElseGet(() -> {
            for (IEnergyStorageProxy energyStorageProxy : ENERGY_STORAGE_PROXIES) {
                Optional<IEnergyStorage> optionalEnergyStorage = energyStorageProxy.getEnergyStorageProxy((BlockGetter)world, pos, facing);
                if (!optionalEnergyStorage.isPresent()) continue;
                return optionalEnergyStorage.orElse(null);
            }
            return null;
        });
        return energyStorage == null ? Optional.empty() : Optional.of(energyStorage);
    }

    public static int fillNeigbours(Level world, BlockPos pos, int energy, boolean simulate) {
        int toFill = energy;
        for (Direction side : Direction.values()) {
            IEnergyStorage energyStorage = EnergyHelpers.getEnergyStorage(world, pos.relative(side), side.getOpposite()).orElse(null);
            if (energyStorage == null || (toFill -= energyStorage.receiveEnergy(toFill, simulate)) > 0) continue;
            return energy;
        }
        return energy - toFill;
    }

    public static interface IEnergyStorageProxy {
        public Optional<IEnergyStorage> getEnergyStorageProxy(BlockGetter var1, BlockPos var2, Direction var3);
    }
}

