/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiBox;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeRecipeValueChangedPacket;

@OnlyIn(value=Dist.CLIENT)
class ValueTypeRecipeLPElementRecipeSubGui
extends RenderPattern<ValueTypeRecipeLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
implements IRenderPatternValueTypeTooltip {
    private boolean renderTooltip = true;
    private WidgetTextFieldExtended inputFluidAmountBox = null;
    private WidgetTextFieldExtended inputEnergyBox = null;
    private WidgetTextFieldExtended outputFluidAmountBox = null;
    private WidgetTextFieldExtended outputEnergyBox = null;

    public ValueTypeRecipeLPElementRecipeSubGui(ValueTypeRecipeLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    protected static WidgetTextFieldExtended makeTextBox(int componentId, int x, int y, String text) {
        Font fontRenderer = Minecraft.getInstance().font;
        int searchWidth = 35;
        Objects.requireNonNull(fontRenderer);
        WidgetTextFieldExtended box = new WidgetTextFieldExtended(fontRenderer, x, y, searchWidth, 9 + 3, (Component)Component.translatable((String)"gui.cyclopscore.search"), true);
        box.setMaxLength(10);
        box.setBordered(false);
        box.setVisible(true);
        box.setTextColor(0xFFFFFF);
        box.setCanLoseFocus(true);
        box.setValue(text);
        box.setWidth(searchWidth);
        return box;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        super.init(guiLeft, guiTop);
        this.inputFluidAmountBox = ValueTypeRecipeLPElementRecipeSubGui.makeTextBox(0, guiLeft + this.getX() + 21, guiTop + this.getY() + 59, ((ValueTypeRecipeLPElement)this.element).getInputFluidAmount());
        this.inputEnergyBox = ValueTypeRecipeLPElementRecipeSubGui.makeTextBox(1, guiLeft + this.getX() + 21, guiTop + this.getY() + 77, ((ValueTypeRecipeLPElement)this.element).getInputEnergy());
        this.outputFluidAmountBox = ValueTypeRecipeLPElementRecipeSubGui.makeTextBox(2, guiLeft + this.getX() + 101, guiTop + this.getY() + 59, ((ValueTypeRecipeLPElement)this.element).getOutputFluidAmount());
        this.outputEnergyBox = ValueTypeRecipeLPElementRecipeSubGui.makeTextBox(3, guiLeft + this.getX() + 101, guiTop + this.getY() + 77, ((ValueTypeRecipeLPElement)this.element).getOutputEnergy());
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
        this.drawTooltipForeground((ContainerScreenLogicProgrammerBase)this.gui, guiGraphics, (ContainerLogicProgrammerBase)this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeRecipeLPElement)this.element).getValueType());
        for (int slotId = 0; slotId < ((ContainerLogicProgrammerBase)this.container).slots.size(); ++slotId) {
            int slotY;
            int slotX;
            Slot slot = (Slot)((ContainerLogicProgrammerBase)this.container).slots.get(slotId);
            if (slotId < 4 || slotId >= 13 || !((ContainerScreenLogicProgrammerBase)this.gui).isHovering(slotX = slot.x, slotY = slot.y, 16, 16, mouseX, mouseY)) continue;
            ((ContainerScreenLogicProgrammerBase)this.gui).drawTooltip(Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"valuetype.integrateddynamics.ingredients.slot.info").withStyle(ChatFormatting.ITALIC)}), guiGraphics.pose(), mouseX - guiLeft, mouseY - guiTop - (slot.getItem().isEmpty() ? 0 : 15));
        }
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        guiGraphics.blit(SubGuiBox.TEXTURE, guiLeft + this.getX() + 66, guiTop + this.getY() + 21, 0, 38, 22, 15);
        this.inputFluidAmountBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        fontRenderer.drawInBatch(L10NHelpers.localize((String)"general.integrateddynamics.energy_unit", (Object[])new Object[0]) + ":", (float)(guiLeft + this.getX() + 2), (float)(guiTop + this.getY() + 78), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.inputEnergyBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.outputFluidAmountBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        fontRenderer.drawInBatch(L10NHelpers.localize((String)"general.integrateddynamics.energy_unit", (Object[])new Object[0]) + ":", (float)(guiLeft + this.getX() + 84), (float)(guiTop + this.getY() + 78), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.outputEnergyBox.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (this.inputFluidAmountBox.charTyped(typedChar, keyCode)) {
            ((ValueTypeRecipeLPElement)this.element).setInputFluidAmount(this.inputFluidAmountBox.getValue());
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getInputFluidAmount(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.INPUT_FLUID));
            return true;
        }
        if (this.inputEnergyBox.charTyped(typedChar, keyCode)) {
            ((ValueTypeRecipeLPElement)this.element).setInputEnergy(this.inputEnergyBox.getValue());
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getInputEnergy(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.INPUT_ENERGY));
            return true;
        }
        if (this.outputFluidAmountBox.charTyped(typedChar, keyCode)) {
            ((ValueTypeRecipeLPElement)this.element).setOutputFluidAmount(this.outputFluidAmountBox.getValue());
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getOutputFluidAmount(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.OUTPUT_FLUID));
            return true;
        }
        if (this.outputEnergyBox.charTyped(typedChar, keyCode)) {
            ((ValueTypeRecipeLPElement)this.element).setOutputEnergy(this.outputEnergyBox.getValue());
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getOutputEnergy(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.OUTPUT_ENERGY));
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.inputFluidAmountBox.keyPressed(typedChar, keyCode, modifiers)) {
            ((ValueTypeRecipeLPElement)this.element).setInputFluidAmount(this.inputFluidAmountBox.getValue());
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getInputFluidAmount(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.INPUT_FLUID));
            return true;
        }
        if (this.inputEnergyBox.keyPressed(typedChar, keyCode, modifiers)) {
            ((ValueTypeRecipeLPElement)this.element).setInputEnergy(this.inputEnergyBox.getValue());
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getInputEnergy(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.INPUT_ENERGY));
            return true;
        }
        if (this.outputFluidAmountBox.keyPressed(typedChar, keyCode, modifiers)) {
            ((ValueTypeRecipeLPElement)this.element).setOutputFluidAmount(this.outputFluidAmountBox.getValue());
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getOutputFluidAmount(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.OUTPUT_FLUID));
            return true;
        }
        if (this.outputEnergyBox.keyPressed(typedChar, keyCode, modifiers)) {
            ((ValueTypeRecipeLPElement)this.element).setOutputEnergy(this.outputEnergyBox.getValue());
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getOutputEnergy(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.OUTPUT_ENERGY));
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.inputFluidAmountBox.mouseClicked(mouseX, mouseY, mouseButton) || this.inputEnergyBox.mouseClicked(mouseX, mouseY, mouseButton) || this.outputFluidAmountBox.mouseClicked(mouseX, mouseY, mouseButton) || this.outputEnergyBox.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isRenderTooltip() {
        return this.renderTooltip;
    }

    @Override
    public void setRenderTooltip(boolean renderTooltip) {
        this.renderTooltip = renderTooltip;
    }

    public WidgetTextFieldExtended getInputFluidAmountBox() {
        return this.inputFluidAmountBox;
    }

    public WidgetTextFieldExtended getInputEnergyBox() {
        return this.inputEnergyBox;
    }

    public WidgetTextFieldExtended getOutputFluidAmountBox() {
        return this.outputFluidAmountBox;
    }

    public WidgetTextFieldExtended getOutputEnergyBox() {
        return this.outputEnergyBox;
    }
}

