/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.cyclops.integrateddynamics.RegistryEntries;

public class RecipeNbtClear
extends CustomRecipe {
    private final Ingredient inputIngredient;

    public RecipeNbtClear(Ingredient inputIngredient) {
        super(CraftingBookCategory.MISC);
        this.inputIngredient = inputIngredient;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        return !this.assemble(inv, (HolderLookup.Provider)worldIn.registryAccess()).isEmpty();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ItemStack ret = ItemStack.EMPTY;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack element = inv.getItem(j);
            if (element.isEmpty()) continue;
            if (this.inputIngredient.test(element)) {
                if (!ret.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                ret = new ItemStack((ItemLike)element.getItem());
                continue;
            }
            return ItemStack.EMPTY;
        }
        return ret;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.inputIngredient.getItems()[0];
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        return NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{this.getResultItem()})});
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_NBT_CLEAR.get();
    }
}

