/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeOperatorLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

public class LogicProgrammerValueTypeOperatorValueChangedPacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<LogicProgrammerValueTypeOperatorValueChangedPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"logic_programmer_value_type_operator_value_changed"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LogicProgrammerValueTypeOperatorValueChangedPacket> CODEC = LogicProgrammerValueTypeOperatorValueChangedPacket.getCodec(LogicProgrammerValueTypeOperatorValueChangedPacket::new);
    @CodecField
    private Tag operatorValue;

    public LogicProgrammerValueTypeOperatorValueChangedPacket() {
        super(ID);
    }

    public LogicProgrammerValueTypeOperatorValueChangedPacket(ValueDeseralizationContext valueDeseralizationContext, ValueTypeOperator.ValueOperator value) {
        super(ID);
        try {
            this.operatorValue = ValueHelpers.serializeRaw(valueDeseralizationContext, value);
        }
        catch (Exception e) {
            this.operatorValue = ByteTag.valueOf((byte)0);
        }
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ILogicProgrammerElement element;
        if (player.containerMenu instanceof ContainerLogicProgrammerBase && (element = ((ContainerLogicProgrammerBase)player.containerMenu).getActiveElement()) instanceof ValueTypeOperatorLPElement) {
            IOperator operator;
            try {
                operator = ValueHelpers.deserializeRaw(ValueDeseralizationContext.of(world), ValueTypes.OPERATOR, this.operatorValue).getRawValue();
            }
            catch (IllegalArgumentException e) {
                operator = null;
            }
            ((ValueTypeOperatorLPElement)element).setSelectedOperator(operator);
            ((ContainerLogicProgrammerBase)player.containerMenu).onDirty();
        }
    }
}

