/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueCastRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public class CastOperator<T1 extends IValueType<V1>, T2 extends IValueType<V2>, V1 extends IValue, V2 extends IValue>
extends OperatorBase {
    private final T1 from;
    private final T2 to;
    private final IValueCastRegistry.IMapping<T1, T2, V1, V2> mapping;

    public CastOperator(T1 from, T2 to, IValueCastRegistry.IMapping<T1, T2, V1, V2> mapping) {
        super("()", from.getTranslationKey() + "$" + to.getTranslationKey(), from.getTypeName() + "To" + Helpers.capitalizeString(to.getTypeName()), null, false, CastOperator.constructInputVariables(1, from), (IValueType)to, new OperatorBase.IFunction(){
            final /* synthetic */ IValueType val$from;
            final /* synthetic */ IValueType val$to;
            final /* synthetic */ IValueCastRegistry.IMapping val$mapping;
            {
                this.val$from = iValueType;
                this.val$to = iValueType2;
                this.val$mapping = iMapping;
            }

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                IValue value = variables.getValue(0);
                if (value.getType() != this.val$from) {
                    throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.cast.unexpected", (Object[])new Object[]{Component.m_237115_((String)value.getType().getTranslationKey()), Component.m_237115_((String)this.val$from.getTranslationKey()), Component.m_237115_((String)this.val$to.getTranslationKey())}));
                }
                return this.val$mapping.cast(value);
            }
        }, IConfigRenderPattern.PREFIX_1);
        this.from = from;
        this.to = to;
        this.mapping = mapping;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation("integrateddynamics", "operator." + this.getModId() + ".cast" + this.from.getUniqueName().toString().replaceAll(":", "_") + "__" + this.to.getUniqueName().toString().replaceAll(":", "_"));
    }

    @Override
    public String getUnlocalizedType() {
        return "cast";
    }

    @Override
    protected String getUnlocalizedPrefix() {
        return "operator." + this.getModId() + "." + this.getUnlocalizedType();
    }

    @Override
    public void loadTooltip(List<Component> lines, boolean appendOptionalInfo) {
        lines.add((Component)Component.m_237110_((String)"operator.integrateddynamics.cast.tooltip", (Object[])new Object[]{Component.m_237115_((String)this.from.getTranslationKey()), Component.m_237115_((String)this.to.getTranslationKey())}));
        super.loadTooltip(lines, appendOptionalInfo);
    }
}

