/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public abstract class ContainerLogicProgrammerBase
extends ScrollingInventoryContainer<ILogicProgrammerElement>
implements IDirtyMarkListener {
    public static final int OUTPUT_X = 232;
    public static final int OUTPUT_Y = 110;
    public static final int BASE_X = 88;
    public static final int BASE_Y = 18;
    public static final int MAX_WIDTH = 160;
    public static final int MAX_HEIGHT = 87;
    protected static final ScrollingInventoryContainer.IItemPredicate<ILogicProgrammerElement> FILTERER = (item, pattern) -> pattern.matcher(item.getMatchString()).matches() || pattern.matcher(item.getSymbol()).matches();
    private final SimpleInventory writeSlot = new SimpleInventory(1, 1);
    private final SimpleInventory filterSlots = new SimpleInventory(3, 1);
    private ILogicProgrammerElement activeElement = null;
    private ILogicProgrammerElement temporarySlotsElement = null;
    private SimpleInventory temporaryInputSlots = null;
    private Component lastError;
    private LoadConfigListener loadConfigListener;
    private IValueType filterIn1 = null;
    private IValueType filterIn2 = null;
    private IValueType filterOut = null;
    @OnlyIn(value=Dist.CLIENT)
    private ContainerScreenLogicProgrammerBase gui;
    private String lastLabel = "";

    public ContainerLogicProgrammerBase(@Nullable MenuType<?> type, int id, Inventory playerInventory) {
        super(type, id, playerInventory, (Container)new SimpleContainer(0), ContainerLogicProgrammerBase.getElements(), FILTERER);
        this.filterSlots.addDirtyMarkListener((IDirtyMarkListener)new FilterSlotListener(ValueDeseralizationContext.of(playerInventory.f_35978_.m_9236_())));
        this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this);
        this.loadConfigListener = new LoadConfigListener();
        this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this.loadConfigListener);
        this.temporaryInputSlots = new SimpleInventory(0, 1);
        this.initializeSlotsPre();
        this.initializeSlotsPost();
    }

    protected static List<ILogicProgrammerElement> getElements() {
        LinkedList elements = Lists.newLinkedList();
        for (ILogicProgrammerElementType type : LogicProgrammerElementTypes.REGISTRY.getTypes()) {
            elements.addAll(type.createElements());
        }
        return elements;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGui(ContainerScreenLogicProgrammerBase gui) {
        this.gui = gui;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ContainerScreenLogicProgrammerBase getGui() {
        return this.gui;
    }

    protected void initializeSlotsPre() {
        this.m_38897_((Slot)new SlotVariable((Container)this.writeSlot, 0, 232, 110){

            public void m_6654_() {
            }
        });
        SlotVariable filterSlotIn1 = new SlotVariable((Container)this.filterSlots, 0, 6, 218);
        SlotVariable filterSlotIn2 = new SlotVariable((Container)this.filterSlots, 1, 24, 218);
        SlotVariable filterSlotOut = new SlotVariable((Container)this.filterSlots, 2, 58, 218);
        filterSlotIn1.setPhantom(true);
        filterSlotIn2.setPhantom(true);
        filterSlotOut.setPhantom(true);
        this.m_38897_((Slot)filterSlotIn1);
        this.m_38897_((Slot)filterSlotIn2);
        this.m_38897_((Slot)filterSlotOut);
    }

    protected void initializeSlotsPost() {
        this.addPlayerInventory(this.getPlayerIInventory(), 88, 131);
    }

    public int getPageSize() {
        return 10;
    }

    protected boolean isAssertInventorySize() {
        return false;
    }

    protected int getSizeInventory() {
        return 1;
    }

    public void setActiveElementById(ResourceLocation typeId, ResourceLocation elementId) {
        ILogicProgrammerElementType type = LogicProgrammerElementTypes.REGISTRY.getType(typeId);
        if (type != null) {
            Object element = type.getByName(elementId);
            if (!LogicProgrammerElementTypes.areEqual(this.getActiveElement(), element)) {
                this.setActiveElement((ILogicProgrammerElement)element, 0, 0);
                this.onDirty();
            }
        } else {
            this.setActiveElement(null, 0, 0);
        }
    }

    public void setActiveElement(ILogicProgrammerElement activeElement, int baseX, int baseY) {
        if (this.activeElement != null) {
            this.activeElement.deactivate();
        }
        this.activeElement = activeElement;
        this.lastError = null;
        this.activeElement = activeElement;
        this.setElementInventory(this.activeElement, baseX, baseY);
        if (activeElement != null) {
            activeElement.activate();
        }
    }

    public void setElementInventory(ILogicProgrammerElement element, int baseX, int baseY) {
        this.lastError = null;
        this.f_38841_.clear();
        this.f_38839_.clear();
        this.f_150394_.clear();
        this.initializeSlotsPre();
        this.temporaryInputSlots.removeDirtyMarkListener((IDirtyMarkListener)this);
        this.temporaryInputSlots = new SimpleInventory(element == null ? 0 : element.getRenderPattern().getSlotPositions().length, element == null ? 0 : element.getItemStackSizeLimit());
        this.temporaryInputSlots.addDirtyMarkListener((IDirtyMarkListener)this);
        this.temporarySlotsElement = element;
        if (element != null) {
            Pair<Integer, Integer>[] slotPositions = element.getRenderPattern().getSlotPositions();
            for (int i = 0; i < this.temporaryInputSlots.m_6643_(); ++i) {
                this.m_38897_(element.createSlot((Container)this.temporaryInputSlots, i, 1 + baseX + (Integer)slotPositions[i].getLeft(), 1 + baseY + (Integer)slotPositions[i].getRight()));
            }
        }
        this.initializeSlotsPost();
        this.lastLabel = "";
    }

    public boolean canWriteActiveElementPre() {
        if (this.activeElement != null) {
            return this.activeElement.canWriteElementPre();
        }
        return false;
    }

    public boolean canWriteActiveElement() {
        if (!this.canWriteActiveElementPre()) {
            return false;
        }
        this.lastError = this.activeElement.validate();
        return this.lastError == null;
    }

    public ILogicProgrammerElement getActiveElement() {
        return this.activeElement;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().m_5776_()) {
            this.returnWriteItemToPlayer();
        }
    }

    public void onLabelPacket(String label) {
        this.lastLabel = label;
        this.labelCurrent();
    }

    protected void labelCurrent() {
        ItemStack itemStack = this.writeSlot.m_8020_(0);
        if (!itemStack.m_41619_()) {
            IVariableFacade variableFacade = RegistryEntries.ITEM_VARIABLE.getVariableFacade(ValueDeseralizationContext.of(this.player.m_9236_()), itemStack);
            if (this.lastLabel != null && variableFacade.isValid()) {
                LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).put(variableFacade.getId(), this.lastLabel);
            }
        }
    }

    protected ItemStack writeElementInfo() {
        ItemStack itemStack = this.writeSlot.m_8020_(0);
        ItemStack result = this.getActiveElement().writeElement(this.player, itemStack.m_41777_());
        return result;
    }

    public void onDirty() {
        ILogicProgrammerElement activeElement = this.getActiveElement();
        if (activeElement != null) {
            for (int i = 0; i < this.temporaryInputSlots.m_6643_(); ++i) {
                ItemStack itemStack = this.temporaryInputSlots.m_8020_(i);
                this.temporarySlotsElement.onInputSlotUpdated(this.player, i, itemStack);
            }
        }
        ItemStack itemStack = this.writeSlot.m_8020_(0);
        if (this.canWriteActiveElement() && !itemStack.m_41619_()) {
            if (itemStack.m_41788_()) {
                this.lastLabel = itemStack.m_41786_().getString();
            }
            ItemStack outputStack = this.writeElementInfo();
            this.writeSlot.removeDirtyMarkListener((IDirtyMarkListener)this);
            this.writeSlot.removeDirtyMarkListener((IDirtyMarkListener)this.loadConfigListener);
            this.writeSlot.m_6836_(0, outputStack);
            if (!StringUtil.m_14408_((String)this.lastLabel)) {
                this.labelCurrent();
            }
            this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this);
            this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this.loadConfigListener);
        }
    }

    protected void loadConfigFrom(ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        IVariableFacade variableFacade = registry.handle(ValueDeseralizationContext.of(this.player.m_9236_()), itemStack);
        for (ILogicProgrammerElement element : this.getUnfilteredItems()) {
            if (!element.isFor(variableFacade)) continue;
            this.writeSlot.removeDirtyMarkListener((IDirtyMarkListener)this);
            this.writeSlot.removeDirtyMarkListener((IDirtyMarkListener)this.loadConfigListener);
            if (MinecraftHelpers.isClientSideThread()) {
                this.getGui().handleElementActivation(element, false);
            } else {
                this.setActiveElement(element, 0, 0);
            }
            this.temporaryInputSlots.removeDirtyMarkListener((IDirtyMarkListener)this);
            element.loadElement(variableFacade);
            if (MinecraftHelpers.isClientSideThread()) {
                element.setValueInGui(this.getGui().getOperatorConfigPattern());
            } else {
                element.setValueInContainer(this);
            }
            this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this);
            this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this.loadConfigListener);
            this.temporaryInputSlots.addDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    public Component getLastError() {
        return this.lastError;
    }

    public SimpleInventory getTemporaryInputSlots() {
        return this.temporaryInputSlots;
    }

    public boolean hasWriteItemInSlot() {
        return !this.writeSlot.m_8020_(0).m_41619_();
    }

    public void returnWriteItemToPlayer() {
        if (this.hasWriteItemInSlot()) {
            ItemStack itemStack = this.writeSlot.m_8020_(0);
            Helpers.returnItemToPlayer(this.player, itemStack);
            this.writeSlot.m_6836_(0, ItemStack.f_41583_);
        }
    }

    protected boolean additionalApplies(ILogicProgrammerElement item) {
        return !((this.filterIn1 != null && !item.matchesInput(this.filterIn1) || this.filterIn2 != null && !item.matchesInput(this.filterIn2)) && (this.filterIn1 != null || this.filterIn2 != null) || this.filterOut != null && !item.matchesOutput(this.filterOut));
    }

    public void m_150399_(int slotId, int mouseButton, ClickType clickType, Player player) {
        if (slotId >= this.f_38839_.size() || this.activeElement != null && this.f_38839_.size() > slotId && slotId >= 0 && this.activeElement.slotClick(slotId, this.m_38853_(slotId), mouseButton, clickType, player)) {
            return;
        }
        super.m_150399_(slotId, mouseButton, clickType, player);
    }

    protected class FilterSlotListener
    implements IDirtyMarkListener {
        private final ValueDeseralizationContext valueDeseralizationContext;

        public FilterSlotListener(ValueDeseralizationContext valueDeseralizationContext) {
            this.valueDeseralizationContext = valueDeseralizationContext;
        }

        protected IValueType getValueType(Container inventory, int slot) {
            IVariableFacade variableFacade;
            IVariableFacadeHandlerRegistry handler = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            if (inventory.m_8020_(slot) != null && (variableFacade = handler.handle(this.valueDeseralizationContext, inventory.m_8020_(slot))).isValid()) {
                return variableFacade.getOutputType();
            }
            return null;
        }

        public void onDirty() {
            IValueType filterIn1Prev = ContainerLogicProgrammerBase.this.filterIn1;
            IValueType filterIn2Prev = ContainerLogicProgrammerBase.this.filterIn2;
            IValueType filterOutPrev = ContainerLogicProgrammerBase.this.filterOut;
            ContainerLogicProgrammerBase.this.filterIn1 = this.getValueType((Container)ContainerLogicProgrammerBase.this.filterSlots, 0);
            ContainerLogicProgrammerBase.this.filterIn2 = this.getValueType((Container)ContainerLogicProgrammerBase.this.filterSlots, 1);
            ContainerLogicProgrammerBase.this.filterOut = this.getValueType((Container)ContainerLogicProgrammerBase.this.filterSlots, 2);
            if (filterIn1Prev != ContainerLogicProgrammerBase.this.filterIn1 || filterIn2Prev != ContainerLogicProgrammerBase.this.filterIn2 || filterOutPrev != ContainerLogicProgrammerBase.this.filterOut) {
                ContainerLogicProgrammerBase.this.refreshFilter();
            }
        }
    }

    protected class LoadConfigListener
    implements IDirtyMarkListener {
        protected LoadConfigListener() {
        }

        public void onDirty() {
            ItemStack itemStack;
            if (ContainerLogicProgrammerBase.this.activeElement == null && !(itemStack = ContainerLogicProgrammerBase.this.writeSlot.m_8020_(0)).m_41619_()) {
                ContainerLogicProgrammerBase.this.loadConfigFrom(itemStack);
            }
        }
    }
}

