/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.color.item.Constant;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeRegistryClient;

public class ValueTypeRegistryClient
implements IValueTypeRegistryClient {
    private Map<IValueType, ItemModel.Unbaked> valueTypeModels = new IdentityHashMap<IValueType, ItemModel.Unbaked>();

    @Override
    public <V extends IValue, T extends IValueType<V>> void registerValueTypeModel(T valueType, ResourceLocation modelLocation) {
        this.valueTypeModels.put(valueType, (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(modelLocation, List.of(new Constant(-1))));
    }

    @Override
    public <V extends IValue, T extends IValueType<V>> ItemModel.Unbaked getValueTypeModel(T valueType) {
        return this.valueTypeModels.get(valueType);
    }

    @Override
    public Collection<ItemModel.Unbaked> getValueTypeModels() {
        return Collections.unmodifiableCollection(this.valueTypeModels.values());
    }
}

