/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeString;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.RenderPattern;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeStringValueChangedPacket;

public class GuiElementValueTypeStringRenderPattern<S extends ISubGuiBox, G extends Screen, C extends AbstractContainerMenu>
extends RenderPattern<GuiElementValueTypeString<G, C>, G, C> {
    protected final GuiElementValueTypeString<G, C> element;
    private WidgetTextFieldExtended textField = null;

    public GuiElementValueTypeStringRenderPattern(GuiElementValueTypeString<G, C> element, int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        this.element = element;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        Font fontRenderer = Minecraft.getInstance().font;
        int searchWidth = ((GuiElementValueTypeString)this.getElement()).getRenderPattern().getWidth() - 28;
        int searchX = this.getX() + 14;
        int searchY = this.getY() + 6;
        Objects.requireNonNull(fontRenderer);
        this.textField = new WidgetTextFieldExtended(fontRenderer, guiLeft + searchX, guiTop + searchY, searchWidth, 9 + 3, (Component)Component.translatable((String)((GuiElementValueTypeString)this.getElement()).getValueType().getTranslationKey()), true);
        this.textField.setMaxLength(512);
        this.textField.setBordered(false);
        this.textField.setVisible(true);
        this.textField.setTextColor(ARGB.opaque((int)0xFFFFFF));
        this.textField.setCanLoseFocus(true);
        String value = this.element.getInputString();
        if (value == null) {
            value = this.element.getDefaultInputString();
        }
        this.textField.setValue(value);
        this.element.setInputString(this.textField.getValue());
        this.textField.setWidth(searchWidth);
        this.textField.setX(guiLeft + (searchX + searchWidth) - this.textField.getWidth());
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        this.textField.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (this.textField.isFocused() && this.textField.charTyped(typedChar, keyCode)) {
            this.onTyped();
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.textField.isFocused()) {
            this.textField.keyPressed(typedChar, keyCode, modifiers);
            this.onTyped();
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    private void onTyped() {
        this.element.setInputString(this.textField.getValue());
        if (this.container instanceof IDirtyMarkListener) {
            ((IDirtyMarkListener)this.container).onDirty();
        }
        this.sendValueToServer();
    }

    @Override
    public void sendValueToServer() {
        super.sendValueToServer();
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeStringValueChangedPacket(this.element.getInputString()));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.textField.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public GuiElementValueTypeString<G, C> getElement() {
        return this.element;
    }

    public WidgetTextFieldExtended getTextField() {
        return this.textField;
    }
}

