/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.facadeable;

import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMultipartTicking;

public class FacadeableTileMultipartTicking
implements IFacadeable {
    private final BlockEntityMultipartTicking tile;

    public FacadeableTileMultipartTicking(BlockEntityMultipartTicking tile) {
        this.tile = tile;
    }

    @Override
    public boolean hasFacade() {
        return this.tile.getFacadeBlockTag() != null;
    }

    @Override
    public BlockState getFacade() {
        if (!this.hasFacade()) {
            return null;
        }
        return BlockHelpers.deserializeBlockState((HolderGetter)ValueDeseralizationContext.of(this.tile.getLevel()).holderLookupProvider().lookupOrThrow(Registries.BLOCK), (CompoundTag)this.tile.getFacadeBlockTag());
    }

    @Override
    public void setFacade(@Nullable BlockState blockState) {
        if (blockState == null) {
            this.tile.setFacadeBlockTag(null);
        } else {
            this.tile.setFacadeBlockTag(BlockHelpers.serializeBlockState((BlockState)blockState));
        }
        this.tile.setForceLightCheckAtClient(true);
        this.tile.sendUpdate();
    }
}

