/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.CapabilityRegistry;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class PartCapability<T>
extends BaseCapability<T, PartTarget> {
    private static final CapabilityRegistry<PartCapability<?>> registry = new CapabilityRegistry((name, type, clazz) -> new PartCapability(name, type));
    final Map<IPartType<?, ?>, List<ICapabilityProvider<IPartType<?, ?>, PartTarget, T>>> providers = new IdentityHashMap();

    public static <T> PartCapability<T> create(ResourceLocation name, Class<T> typeClass) {
        return (PartCapability)((Object)registry.create(name, typeClass, PartTarget.class));
    }

    public static synchronized List<PartCapability<?>> getAll() {
        return registry.getAll();
    }

    private PartCapability(ResourceLocation name, Class<T> typeClass) {
        super(name, typeClass, PartTarget.class);
    }

    @ApiStatus.Internal
    @Nullable
    public T getCapability(IPartType<?, ?> partType, PartTarget context) {
        for (ICapabilityProvider provider : this.providers.getOrDefault(partType, List.of())) {
            Object ret = provider.getCapability(partType, (Object)context);
            if (ret == null) continue;
            return (T)ret;
        }
        return null;
    }
}

