/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMechanicalMachine;

public abstract class ContainerScreenMechanicalMachine<C extends ContainerMechanicalMachine<?>>
extends ContainerScreenExtended<C> {
    public ContainerScreenMechanicalMachine(C container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    public void drawEnergyBarTooltip(PoseStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((AbstractContainerScreen)this, (PoseStack)poseStack, (int)8, (int)16, (int)18, (int)60, (int)mouseX, (int)mouseY, () -> {
            int energyStored = ((ContainerMechanicalMachine)this.getMenu()).getEnergy();
            int energyMax = ((ContainerMechanicalMachine)this.getMenu()).getMaxEnergy();
            if (energyMax > 0) {
                return Optional.of(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"general.integrateddynamics.energy"), Helpers.getLocalizedEnergyLevel(energyStored, energyMax)}));
            }
            return Optional.empty();
        });
    }

    public void drawFluidTankTooltip(PoseStack poseStack, FluidStack fluidStack, int fluidCapacity, int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((AbstractContainerScreen)this, (PoseStack)poseStack, (int)x, (int)y, (int)width, (int)height, (int)mouseX, (int)mouseY, () -> {
            if (fluidStack != null && !fluidStack.isEmpty()) {
                Component fluidName = fluidStack.getHoverName();
                return Optional.of(Lists.newArrayList((Object[])new Component[]{fluidName, DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)fluidStack.getAmount(), (int)fluidCapacity)}));
            }
            return Optional.empty();
        });
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        this.font.drawInBatch(this.title, (float)this.titleLabelX, (float)this.titleLabelY, 0x404040, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

