/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public abstract class ContainerMultipart<P extends IPartType<P, S>, S extends IPartState<P>>
extends InventoryContainer
implements IDirtyMarkListener {
    public static final String BUTTON_SETTINGS = "button_settings";
    public static final String BUTTON_OFFSETS = "button_offsets";
    private static final int PAGE_SIZE = 3;
    private final Optional<PartTarget> target;
    private final Optional<IPartContainer> partContainer;
    private final P partType;
    private final Level world;

    public ContainerMultipart(@Nullable MenuType<?> type, int id, Inventory playerInventory, Container inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, P partType) {
        super(type, id, playerInventory, inventory);
        this.target = target;
        this.partType = partType;
        this.partContainer = partContainer;
        this.world = this.player.getCommandSenderWorld();
        this.putButtonAction(BUTTON_SETTINGS, (s, containerExtended) -> {
            if (!this.world.isClientSide()) {
                PartHelpers.openContainerPart((ServerPlayer)this.player, ((PartTarget)target.get()).getCenter(), partType);
            }
        });
        this.putButtonAction(BUTTON_OFFSETS, (s, containerExtended) -> {
            if (!this.world.isClientSide()) {
                PartHelpers.openContainerPartOffsets((ServerPlayer)this.player, ((PartTarget)target.get()).getCenter(), partType);
            }
        });
    }

    public Level getLevel() {
        return this.world;
    }

    public P getPartType() {
        return this.partType;
    }

    public Optional<PartTarget> getTarget() {
        return this.target;
    }

    public Optional<S> getPartState() {
        return this.partContainer.map(p -> p.getPartState(this.getTarget().get().getCenter().getSide()));
    }

    public Optional<IPartContainer> getPartContainer() {
        return this.partContainer;
    }

    public boolean stillValid(Player playerIn) {
        return PartHelpers.canInteractWith(this.getTarget().get(), this.player, this.partContainer.get());
    }

    public void onDirty() {
    }
}

