/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.mojang.serialization.MapCodec;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.core.client.model.ItemModelVariableOverlays;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;
import org.jetbrains.annotations.Nullable;

public record ItemModelVariableOverlay(ItemModelVariableOverlays variableModelBaked) implements ItemModel
{
    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        ItemModel model = this.variableModelBaked.getModelForItem(stack, (Level)level);
        if (model != null) {
            model.update(renderState, stack, itemModelResolver, displayContext, level, entity, seed);
        }
    }

    public record Unbaked() implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)new Unbaked());

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext bakingContext) {
            ItemModelVariableOverlays bakedModel = new ItemModelVariableOverlays();
            for (IVariableModelProvider<? extends IVariableModelProvider.BakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
                bakedModel.setSubModels(provider, provider.bakeOverlayModels(bakingContext));
            }
            return new ItemModelVariableOverlay(bakedModel);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            for (IVariableModelProvider<? extends IVariableModelProvider.BakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
                provider.resolveDependencies(resolver);
            }
        }
    }
}

