/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import com.google.common.base.Predicates;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElementValueType;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeStringClient;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeStringRenderPattern;

public class GuiElementValueTypeString<G extends Screen, C extends AbstractContainerMenu>
implements IGuiInputElementValueType<GuiElementValueTypeStringRenderPattern, G, C, GuiElementValueTypeStringClient<G, C>> {
    private final IValueType valueType;
    private Predicate<IValue> validator;
    private final IConfigRenderPattern renderPattern;
    private String defaultInputString;
    private String inputString;

    public GuiElementValueTypeString(IValueType valueType, IConfigRenderPattern renderPattern) {
        this.valueType = valueType;
        this.validator = Predicates.alwaysTrue();
        this.renderPattern = renderPattern;
        this.defaultInputString = ValueHelpers.toString(this.getValueType().getDefault());
    }

    @Override
    public void setValue(IValue value) {
        this.setInputString(ValueHelpers.toString(value));
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    @Override
    public void setValidator(Predicate<IValue> validator) {
        this.validator = validator;
    }

    @Override
    public IValue getValue() {
        try {
            return ValueHelpers.parseString(this.getValueType(), this.getInputString());
        }
        catch (EvaluationException e) {
            return this.getValueType().getDefault();
        }
    }

    @Override
    public GuiElementValueTypeStringClient<G, C> getClient() {
        return new GuiElementValueTypeStringClient(this);
    }

    @Override
    public Component getName() {
        return Component.translatable((String)this.getValueType().getTranslationKey());
    }

    @Override
    public void loadTooltip(Consumer<Component> tooltipAdder) {
        this.getValueType().loadTooltip(tooltipAdder, true, null);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public void activate() {
        this.inputString = this.defaultInputString;
    }

    @Override
    public void deactivate() {
        this.inputString = null;
    }

    @Override
    public Component validate() {
        try {
            Object value = this.getValueType().parseString(this.inputString);
            if (!this.validator.test((IValue)value)) {
                return Component.translatable((String)"valuetype.integrateddynamics.error.value");
            }
        }
        catch (EvaluationException e) {
            return e.getErrorMessage();
        }
        return null;
    }

    @Override
    public int getColor() {
        return this.getValueType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return IModHelpers.get().getL10NHelpers().localize(this.getValueType().getTranslationKey(), new Object[0]);
    }

    public IValueType getValueType() {
        return this.valueType;
    }

    public Predicate<IValue> getValidator() {
        return this.validator;
    }

    public String getDefaultInputString() {
        return this.defaultInputString;
    }

    public String getInputString() {
        return this.inputString;
    }

    public void setDefaultInputString(String defaultInputString) {
        this.defaultInputString = defaultInputString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiElementValueTypeString)) {
            return false;
        }
        GuiElementValueTypeString other = (GuiElementValueTypeString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IValueType this$valueType = this.getValueType();
        IValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        Predicate<IValue> this$validator = this.getValidator();
        Predicate<IValue> other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        IConfigRenderPattern this$renderPattern = this.getRenderPattern();
        IConfigRenderPattern other$renderPattern = other.getRenderPattern();
        if (this$renderPattern == null ? other$renderPattern != null : !this$renderPattern.equals(other$renderPattern)) {
            return false;
        }
        String this$defaultInputString = this.getDefaultInputString();
        String other$defaultInputString = other.getDefaultInputString();
        if (this$defaultInputString == null ? other$defaultInputString != null : !this$defaultInputString.equals(other$defaultInputString)) {
            return false;
        }
        String this$inputString = this.getInputString();
        String other$inputString = other.getInputString();
        return !(this$inputString == null ? other$inputString != null : !this$inputString.equals(other$inputString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiElementValueTypeString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        Predicate<IValue> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
        IConfigRenderPattern $renderPattern = this.getRenderPattern();
        result = result * 59 + ($renderPattern == null ? 43 : $renderPattern.hashCode());
        String $defaultInputString = this.getDefaultInputString();
        result = result * 59 + ($defaultInputString == null ? 43 : $defaultInputString.hashCode());
        String $inputString = this.getInputString();
        result = result * 59 + ($inputString == null ? 43 : $inputString.hashCode());
        return result;
    }

    public String toString() {
        return "GuiElementValueTypeString(valueType=" + String.valueOf(this.getValueType()) + ", validator=" + String.valueOf(this.getValidator()) + ", renderPattern=" + String.valueOf(this.getRenderPattern()) + ", defaultInputString=" + this.getDefaultInputString() + ", inputString=" + this.getInputString() + ")";
    }
}

