/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.display.RecipeDisplayDryingBasin;

public class RecipeDryingBasin
implements Recipe<IInventoryFluid> {
    private final Optional<Ingredient> inputIngredient;
    private final Optional<FluidStack> inputFluid;
    private final Optional<Either<ItemStack, ItemStackFromIngredient>> outputItem;
    private final Optional<FluidStack> outputFluid;
    private final int duration;
    private PlacementInfo placementInfo;

    public RecipeDryingBasin(Optional<Ingredient> inputIngredient, Optional<FluidStack> inputFluid, Optional<Either<ItemStack, ItemStackFromIngredient>> outputIngredient, Optional<FluidStack> outputFluid, int duration) {
        this.inputIngredient = inputIngredient;
        this.inputFluid = inputFluid;
        this.outputItem = outputIngredient;
        this.outputFluid = outputFluid;
        this.duration = duration;
    }

    public Optional<Ingredient> getInputIngredient() {
        return this.inputIngredient;
    }

    public Optional<FluidStack> getInputFluid() {
        return this.inputFluid;
    }

    public Optional<Either<ItemStack, ItemStackFromIngredient>> getOutputItem() {
        return this.outputItem;
    }

    public Optional<ItemStack> getOutputItemFirst() {
        return this.getOutputItem().map(either -> (ItemStack)either.map(l -> l, ItemStackFromIngredient::getFirstItemStack));
    }

    public Optional<FluidStack> getOutputFluid() {
        return this.outputFluid;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean matches(IInventoryFluid inv, Level worldIn) {
        return this.inputIngredient.map(p -> p.test(inv.getItem(0))).orElse(inv.getItem(0).isEmpty()) != false && this.inputFluid.map(f -> f.getFluid() == inv.getFluidHandler().getFluidInTank(0).getFluid()).orElse(inv.getFluidHandler().getFluidInTank(0).isEmpty()) != false && this.inputFluid.map(f -> f.getAmount() <= inv.getFluidHandler().getFluidInTank(0).getAmount()).orElse(inv.getFluidHandler().getFluidInTank(0).isEmpty()) != false;
    }

    public ItemStack assemble(IInventoryFluid inv, HolderLookup.Provider registryAccess) {
        return this.getOutputItemFirst().get().copy();
    }

    public RecipeSerializer<? extends Recipe<IInventoryFluid>> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_DRYING_BASIN.get();
    }

    public RecipeType<? extends Recipe<IInventoryFluid>> getType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_DRYING_BASIN.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create((Ingredient)this.inputIngredient.orElse(Ingredient.of((ItemLike)Items.BUCKET)));
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)RegistryEntries.RECIPEBOOKCATEGORY_DRYING_BASIN.get();
    }

    public List<RecipeDisplay> display() {
        return List.of(new RecipeDisplayDryingBasin(this.getInputIngredient().map(Ingredient::display).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE), this.getInputFluid().orElse(FluidStack.EMPTY), this.getOutputItemFirst().map(SlotDisplay.ItemStackSlotDisplay::new).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE), this.getOutputFluid().orElse(FluidStack.EMPTY), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(((BlockDryingBasin)((Object)RegistryEntries.BLOCK_DRYING_BASIN.get())).asItem()), this.getDuration()));
    }
}

