/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public abstract class BlockEntityCableConnectable
extends CyclopsBlockEntity {
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private final ICable cable = new CableTile<BlockEntityCableConnectable>(this, this){

        @Override
        protected boolean isForceDisconnectable() {
            return false;
        }

        @Override
        protected EnumFacingMap<Boolean> getForceDisconnected() {
            return null;
        }

        @Override
        protected EnumFacingMap<Boolean> getConnected() {
            return ((BlockEntityCableConnectable)this.tile).connected;
        }
    };
    private final INetworkCarrier networkCarrier = new NetworkCarrierDefault();

    public BlockEntityCableConnectable(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public ICable getCable() {
        return this.cable;
    }

    public INetworkCarrier getNetworkCarrier() {
        return this.networkCarrier;
    }

    public abstract INetworkElementProvider getNetworkElementProvider();

    public void read(ValueInput input) {
        super.read(input);
        this.connected.clear();
    }

    public void onChunkUnloaded() {
        INetwork network;
        super.onChunkUnloaded();
        if (this.getLevel() != null && !this.getLevel().isClientSide && (network = this.getNetworkCarrier().getNetwork()) != null) {
            NetworkHelpers.invalidateNetworkElements(this.getLevel(), this.getBlockPos(), network, this.getNetworkElementProvider());
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        if (!CableHelpers.isRemovingCable()) {
            CableHelpers.onCableRemoving(this.level, pos, false, false, state, (BlockEntity)this);
        }
    }

    public static class Ticker<T extends BlockEntityCableConnectable>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityCableConnectable)((Object)blockEntity)).getConnected().isEmpty()) {
                ((BlockEntityCableConnectable)((Object)blockEntity)).getCable().updateConnections();
            }
            NetworkHelpers.revalidateNetworkElements(level, pos);
        }
    }

    public static class CapabilityRegistrar<T extends BlockEntityCableConnectable>
    extends BlockEntityCapabilityRegistrar<T> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends T>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.Cable.BLOCK, (blockEntity, context) -> blockEntity.getCable());
            this.add(Capabilities.NetworkCarrier.BLOCK, (blockEntity, context) -> blockEntity.getNetworkCarrier());
            this.add(Capabilities.PathElement.BLOCK, (blockEntity, context) -> new PathElementTile<BlockEntityCableConnectable>((BlockEntityCableConnectable)((Object)blockEntity), blockEntity.getCable()));
        }
    }
}

