/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerScreenPartSettings<T extends ContainerPartSettings>
extends ContainerScreenExtended<T> {
    private WidgetNumberField numberFieldUpdateInterval = null;
    private WidgetNumberField numberFieldPriority = null;
    private WidgetNumberField numberFieldChannel = null;
    private WidgetTextFieldDropdown<Direction> dropdownFieldSide = null;
    private List<SideDropdownEntry> dropdownEntries;

    public ContainerScreenPartSettings(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected void onSave() {
        try {
            if (this.isFieldSideEnabled()) {
                Direction selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
                int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartSettings)this.getMenu()).getLastSideValueId(), (int)side);
            }
            if (this.isFieldUpdateIntervalEnabled()) {
                int updateInterval = this.numberFieldUpdateInterval.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartSettings)this.getMenu()).getLastUpdateValueId(), (int)updateInterval);
            }
            if (this.isFieldPriorityEnabled()) {
                int priority = this.numberFieldPriority.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartSettings)this.getMenu()).getLastPriorityValueId(), (int)priority);
            }
            if (this.isFieldChannelEnabled()) {
                int channel = this.numberFieldChannel.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartSettings)this.getMenu()).getLastChannelValueId(), (int)channel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"textures/gui/part_settings.png");
    }

    protected Direction getCurrentSide() {
        return ((ContainerPartSettings)this.getMenu()).getTarget().getTarget().getSide();
    }

    protected Direction getDefaultSide() {
        return ((ContainerPartSettings)this.getMenu()).getTarget().getCenter().getSide().getOpposite();
    }

    protected String getSideText(Direction side) {
        return side.getSerializedName().toLowerCase(Locale.ENGLISH);
    }

    public void init() {
        super.init();
        if (this.isFieldSideEnabled()) {
            this.dropdownEntries = Arrays.stream(Direction.values()).map(x$0 -> new SideDropdownEntry((Direction)x$0)).collect(Collectors.toList());
            this.dropdownFieldSide = new WidgetTextFieldDropdown(this.font, this.leftPos + 106, this.topPos + this.getFieldSideY(), 70, 14, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.side"), true, Sets.newHashSet(this.dropdownEntries));
            this.setSideInDropdownField(this.getCurrentSide());
            this.dropdownFieldSide.setMaxLength(15);
            this.dropdownFieldSide.setVisible(true);
            this.dropdownFieldSide.setTextColor(ARGB.opaque((int)0xFFFFFF));
            this.dropdownFieldSide.setCanLoseFocus(true);
        }
        if (this.isFieldUpdateIntervalEnabled()) {
            this.numberFieldUpdateInterval = new WidgetNumberField(this.font, this.leftPos + 106, this.topPos + this.getFieldUpdateIntervalY(), 70, 14, true, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.update_interval"), true);
            this.numberFieldUpdateInterval.setMaxLength(15);
            this.numberFieldUpdateInterval.setVisible(true);
            this.numberFieldUpdateInterval.setTextColor(ARGB.opaque((int)0xFFFFFF));
            this.numberFieldUpdateInterval.setCanLoseFocus(true);
            this.numberFieldUpdateInterval.setMinValue(((ContainerPartSettings)this.container).getLastMinUpdateValue());
        }
        if (this.isFieldPriorityEnabled()) {
            this.numberFieldPriority = new WidgetNumberField(this.font, this.leftPos + 106, this.topPos + this.getFieldPriorityY(), 70, 14, true, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.priority"), true);
            this.numberFieldPriority.setPositiveOnly(false);
            this.numberFieldPriority.setMaxLength(15);
            this.numberFieldPriority.setVisible(true);
            this.numberFieldPriority.setTextColor(ARGB.opaque((int)0xFFFFFF));
            this.numberFieldPriority.setCanLoseFocus(true);
        }
        if (this.isFieldChannelEnabled()) {
            this.numberFieldChannel = new WidgetNumberField(this.font, this.leftPos + 106, this.topPos + this.getFieldChannelY(), 70, 14, true, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.channel"), true);
            this.numberFieldChannel.setPositiveOnly(false);
            this.numberFieldChannel.setMaxLength(15);
            this.numberFieldChannel.setVisible(true);
            this.numberFieldChannel.setTextColor(ARGB.opaque((int)0xFFFFFF));
            this.numberFieldChannel.setCanLoseFocus(true);
            this.numberFieldChannel.setEditable(this.isChannelEnabled());
        }
        MutableComponent save = Component.translatable((String)"gui.integrateddynamics.button.save");
        this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 178, this.topPos + 8, this.font.width(save.getVisualOrderText()) + 6, 16, (Component)save, (Component)save, this.createServerPressable("button_save", b -> this.onSave()), true));
        this.refreshValues();
    }

    protected int getFieldSideY() {
        return 9;
    }

    protected int getFieldUpdateIntervalY() {
        return 34;
    }

    protected int getFieldPriorityY() {
        return 59;
    }

    protected int getFieldChannelY() {
        return 84;
    }

    protected boolean isFieldSideEnabled() {
        return true;
    }

    protected boolean isFieldUpdateIntervalEnabled() {
        return true;
    }

    protected boolean isFieldPriorityEnabled() {
        return true;
    }

    protected boolean isFieldChannelEnabled() {
        return true;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!(this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.charTyped(typedChar, keyCode) || this.isFieldPriorityEnabled() && this.numberFieldPriority.charTyped(typedChar, keyCode) || this.isFieldChannelEnabled() && this.numberFieldChannel.charTyped(typedChar, keyCode) || this.isFieldSideEnabled() && this.dropdownFieldSide.charTyped(typedChar, keyCode))) {
            return super.charTyped(typedChar, keyCode);
        }
        return true;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.isFieldSideEnabled() && this.dropdownFieldSide.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldPriorityEnabled() && this.numberFieldPriority.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldChannelEnabled() && this.numberFieldChannel.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isFieldSideEnabled() && this.dropdownFieldSide.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldPriorityEnabled() && this.numberFieldPriority.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldChannelEnabled() && this.numberFieldChannel.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.isFieldUpdateIntervalEnabled()) {
            guiGraphics.drawString(this.font, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.partsettings.update_interval", new Object[0]), this.leftPos + 8, this.topPos + this.getFieldUpdateIntervalY() + 3, ARGB.opaque((int)0), false);
            this.numberFieldUpdateInterval.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldPriorityEnabled()) {
            guiGraphics.drawString(this.font, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.partsettings.priority", new Object[0]), this.leftPos + 8, this.topPos + this.getFieldPriorityY() + 3, ARGB.opaque((int)0), false);
            this.numberFieldPriority.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldChannelEnabled()) {
            guiGraphics.drawString(this.font, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.partsettings.channel", new Object[0]), this.leftPos + 8, this.topPos + this.getFieldChannelY() + 3, this.isChannelEnabled() ? ARGB.opaque((int)0) : IModHelpers.get().getBaseHelpers().RGBAToInt(100, 100, 100, 255), false);
            this.numberFieldChannel.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldSideEnabled()) {
            guiGraphics.drawString(this.font, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.partsettings.side", new Object[0]), this.leftPos + 8, this.topPos + this.getFieldSideY() + 3, ARGB.opaque((int)0), false);
            this.dropdownFieldSide.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!this.isChannelEnabled()) {
            IModHelpers.get().getGuiHelpers().renderTooltip((AbstractContainerScreen)this, guiGraphics, 8, 87, 100, 20, mouseX, mouseY, () -> Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.partsettings.channel.disabledinfo")}));
        }
    }

    protected boolean isChannelEnabled() {
        return GeneralConfig.energyConsumptionMultiplier > 0;
    }

    protected int getBaseXSize() {
        return 214;
    }

    protected int getBaseYSize() {
        return 191;
    }

    protected void setSideInDropdownField(Direction side) {
        this.dropdownFieldSide.selectPossibility(this.dropdownEntries.get(side.ordinal()));
    }

    public void onUpdate(int valueId, CompoundTag value) {
        if (this.isFieldSideEnabled() && valueId == ((ContainerPartSettings)this.getMenu()).getLastSideValueId()) {
            int side = ((ContainerPartSettings)this.getMenu()).getLastSideValue();
            this.setSideInDropdownField(side == -1 ? this.getDefaultSide() : Direction.values()[side]);
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.getMenu()).getLastUpdateValueId()) {
            this.numberFieldUpdateInterval.setValue(Integer.toString(((ContainerPartSettings)this.getMenu()).getLastUpdateValue()));
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.getMenu()).getLastMinUpdateValueId()) {
            this.numberFieldUpdateInterval.setMinValue(((ContainerPartSettings)this.getMenu()).getLastMinUpdateValue());
        }
        if (this.isFieldPriorityEnabled() && valueId == ((ContainerPartSettings)this.getMenu()).getLastPriorityValueId()) {
            this.numberFieldPriority.setValue(Integer.toString(((ContainerPartSettings)this.getMenu()).getLastPriorityValue()));
        }
        if (this.isFieldChannelEnabled() && valueId == ((ContainerPartSettings)this.getMenu()).getLastChannelValueId()) {
            this.numberFieldChannel.setValue(Integer.toString(((ContainerPartSettings)this.getMenu()).getLastChannelValue()));
        }
    }

    public class SideDropdownEntry
    implements IDropdownEntry<Direction> {
        private final Direction side;

        public SideDropdownEntry(Direction side) {
            this.side = side;
        }

        @Override
        public String getMatchString() {
            return ContainerScreenPartSettings.this.getSideText(this.side);
        }

        @Override
        public MutableComponent getDisplayString() {
            if (ContainerScreenPartSettings.this.getDefaultSide() == this.side) {
                return Component.literal((String)this.getMatchString()).withStyle(ChatFormatting.YELLOW);
            }
            return Component.literal((String)this.getMatchString());
        }

        @Override
        public List<MutableComponent> getTooltip() {
            return Collections.emptyList();
        }

        @Override
        public Direction getValue() {
            return this.side;
        }
    }
}

