/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalDryingBasin;

public class GameTestsMechanicalDryingBasin {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testMechanicalDryingBasin(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_MECHANICAL_DRYING_BASIN.value());
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        BlockEntityMechanicalDryingBasin machine = (BlockEntityMechanicalDryingBasin)helper.getBlockEntity(POS, BlockEntityMechanicalDryingBasin.class);
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.north(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(100000);
        machine.getTankInput().setFluid(new FluidStack((Fluid)RegistryEntries.FLUID_MENRIL_RESIN.get(), 1000));
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)machine.getInventory().getItem(1).getItem(), (Object)((Block)RegistryEntries.BLOCK_CRYSTALIZED_MENRIL_BLOCK.get()).asItem(), (Component)Component.literal((String)"Machine did not produce item output"));
            helper.assertTrue(machine.getTankInput().getFluid().isEmpty(), (Component)Component.literal((String)"Machine did not consume fluid input"));
            helper.assertTrue(battery.getEnergyStored() < 100000, (Component)Component.literal((String)"Energy in battery did not decrease"));
        });
    }
}

