/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.ARGB;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendixClient;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.infobook.pageelement.OperatorAppendix;

public class OperatorAppendixClient
extends SectionAppendixClient<OperatorAppendix> {
    protected OperatorAppendixClient(OperatorAppendix sectionAppendix) {
        super((SectionAppendix)sectionAppendix);
    }

    protected void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        OperatorAppendix section = (OperatorAppendix)this.getSectionAppendix();
        IOperator operator = section.getOperator();
        int yOffset = 5;
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1 - yOffset, section.getWidth() + 2, section.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize("operator.integrateddynamics", new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, IModHelpers.get().getBaseHelpers().RGBAToInt(30, 20, 120, 255));
        String operatorName = IModHelpers.get().getL10NHelpers().localize(operator.getTranslationKey(), new Object[0]);
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize(operatorName, new Object[0]) + " (" + operator.getSymbol() + ")", x, y + 8, width, 1.0f, gui.getBannerWidth(), ARGB.opaque((int)0));
        IValueType[] inputTypes = operator.getInputTypes();
        int offsetY = 14;
        for (int i = 0; i < inputTypes.length; ++i) {
            guiGraphics.drawString(gui.getFont(), IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.input", new Object[]{i + 1 + ": " + String.valueOf(inputTypes[i].getDisplayColorFormat()) + IModHelpers.get().getL10NHelpers().localize(inputTypes[i].getTranslationKey(), new Object[0])}), x, y + offsetY, ARGB.opaque((int)0), false);
            offsetY += 8;
        }
        String outputTypeName = IModHelpers.get().getL10NHelpers().localize(operator.getOutputType().getTranslationKey(), new Object[0]);
        guiGraphics.drawString(gui.getFont(), IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.output", new Object[]{String.valueOf(operator.getOutputType().getDisplayColorFormat()) + outputTypeName}), x, y + offsetY, ARGB.opaque((int)0), false);
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.operator.globalname", new Object[]{operator.getGlobalInteractName()}), x, y + (offsetY += 8) + 6, width, 1.0f, gui.getBannerWidth(), ARGB.opaque((int)0));
        offsetY += 8;
        if (operator.getInputTypes().length > 0) {
            String scopedTypeName = IModHelpers.get().getL10NHelpers().localize(operator.getInputTypes()[0].getTranslationKey(), new Object[0]);
            gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.operator.localname", new Object[]{String.valueOf(operator.getInputTypes()[0].getDisplayColorFormat()) + scopedTypeName + "." + operator.getScopedInteractName()}), x, y + offsetY + 6, width, 1.0f, gui.getBannerWidth(), ARGB.opaque((int)0));
        }
    }

    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        if (mx >= x && my >= y && mx <= x + ((OperatorAppendix)this.getSectionAppendix()).getWidth()) {
            Objects.requireNonNull(gui.getFont());
            if (my <= y + 9) {
                ArrayList lines = Lists.newArrayList();
                ((OperatorAppendix)this.getSectionAppendix()).getOperator().loadTooltip(lines::add, true);
                guiGraphics.setComponentTooltipForNextFrame(gui.getFont(), (List)lines, mx, my);
            }
        }
    }
}

