/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntitySqueezer;

public class BlockSqueezer
extends BlockWithEntity {
    public static final MapCodec<BlockSqueezer> CODEC = BlockSqueezer.simpleCodec(BlockSqueezer::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final IntegerProperty HEIGHT = IntegerProperty.create((String)"height", (int)1, (int)7);
    private static final VoxelShape[] SHAPES_BLOCK = new VoxelShape[]{null, BlockSqueezer.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), BlockSqueezer.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), BlockSqueezer.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), BlockSqueezer.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), BlockSqueezer.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), BlockSqueezer.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), BlockSqueezer.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)};
    private static final VoxelShape[] SHAPES_STICKS = new VoxelShape[]{BlockSqueezer.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), BlockSqueezer.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), BlockSqueezer.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), BlockSqueezer.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] SHAPES = new VoxelShape[]{null, Shapes.or((VoxelShape)SHAPES_BLOCK[1], (VoxelShape[])SHAPES_STICKS), Shapes.or((VoxelShape)SHAPES_BLOCK[2], (VoxelShape[])SHAPES_STICKS), Shapes.or((VoxelShape)SHAPES_BLOCK[3], (VoxelShape[])SHAPES_STICKS), Shapes.or((VoxelShape)SHAPES_BLOCK[4], (VoxelShape[])SHAPES_STICKS), Shapes.or((VoxelShape)SHAPES_BLOCK[5], (VoxelShape[])SHAPES_STICKS), Shapes.or((VoxelShape)SHAPES_BLOCK[6], (VoxelShape[])SHAPES_STICKS), Shapes.or((VoxelShape)SHAPES_BLOCK[7], (VoxelShape[])SHAPES_STICKS)};

    public BlockSqueezer(BlockBehaviour.Properties properties) {
        super(properties, BlockEntitySqueezer::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)HEIGHT, (Comparable)Integer.valueOf(1)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockSqueezer.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SQUEEZER.get()), (BlockEntityTicker)new BlockEntitySqueezer.Ticker());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, HEIGHT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis());
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult blockRayTraceResult) {
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if ((Integer)world.getBlockState(blockPos).getValue((Property)HEIGHT) == 1) {
            return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntitySqueezer.class).map(tile -> {
                ItemStack itemStack = player.getInventory().getSelected();
                ItemStack tileStack = tile.getInventory().getItem(0);
                if (itemStack.isEmpty() && !tileStack.isEmpty()) {
                    player.getInventory().setItem(player.getInventory().selected, tileStack);
                    tile.getInventory().setItem(0, ItemStack.EMPTY);
                    tile.sendUpdate();
                    return InteractionResult.SUCCESS;
                }
                if (player.getInventory().add(tileStack)) {
                    tile.getInventory().setItem(0, ItemStack.EMPTY);
                    tile.sendUpdate();
                    return InteractionResult.SUCCESS;
                }
                if (!itemStack.isEmpty() && tile.getInventory().getItem(0).isEmpty()) {
                    tile.getInventory().setItem(0, itemStack.split(1));
                    if (itemStack.getCount() <= 0) {
                        player.getInventory().setItem(player.getInventory().selected, ItemStack.EMPTY);
                    }
                    tile.sendUpdate();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        double motionY = entityIn.getDeltaMovement().y;
        super.updateEntityAfterFallOn(worldIn, entityIn);
        if (!entityIn.level().isClientSide() && motionY <= -0.37 && entityIn instanceof LivingEntity) {
            int i = Mth.floor((double)entityIn.getX());
            int j = Mth.floor((double)(entityIn.getY() - 0.2));
            int k = Mth.floor((double)entityIn.getZ());
            BlockPos blockPos = new BlockPos(i, j, k);
            BlockState blockState = worldIn.getBlockState(blockPos);
            int steps = 1 + Mth.floor((double)((-motionY - 0.37) * 5.0));
            if (blockState.getBlock() == this && entityIn.getY() - (double)blockPos.getY() - (double)this.getRelativeTopPositionTop(worldIn, blockPos, blockState) <= (double)0.1f) {
                int newHeight = Math.min(7, (Integer)blockState.getValue((Property)HEIGHT) + steps);
                entityIn.level().setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)HEIGHT, (Comparable)Integer.valueOf(newHeight)));
                BlockEntityHelpers.get((BlockGetter)worldIn, (BlockPos)blockPos, BlockEntitySqueezer.class).ifPresent(tile -> tile.setItemHeight(Math.max(newHeight, tile.getItemHeight())));
            }
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, neighborBlock, fromPos, isMoving);
        if (!worldIn.isClientSide) {
            for (Direction enumfacing : Direction.values()) {
                if (!worldIn.hasSignal(pos.relative(enumfacing), enumfacing)) continue;
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HEIGHT, (Comparable)Integer.valueOf(1)));
                for (Entity entity : worldIn.getEntitiesOfClass(Entity.class, new AABB(Vec3.atLowerCornerOf((Vec3i)pos), Vec3.atLowerCornerOf((Vec3i)pos.offset(1, 1, 1))))) {
                    entity.getDeltaMovement().add(0.0, 0.25, 0.0);
                    entity.setDeltaMovement(0.0, 1.0, 0.0);
                }
                return;
            }
        }
    }

    public float getRelativeTopPositionTop(BlockGetter world, BlockPos blockPos, BlockState blockState) {
        return (float)(9 - (Integer)blockState.getValue((Property)HEIGHT)) * 0.125f;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPES[(Integer)blockState.getValue((Property)HEIGHT)];
    }

    public VoxelShape getInteractionShape(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        return SHAPES_BLOCK[(Integer)blockState.getValue((Property)HEIGHT)];
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPES_BLOCK[(Integer)blockState.getValue((Property)HEIGHT)];
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos blockPos) {
        return (int)(((double)((Integer)blockState.getValue((Property)HEIGHT)).intValue() - 1.0) / 6.0 * 15.0);
    }

    public void onRemove(BlockState oldState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!oldState.is(newState.getBlock())) {
            BlockEntityHelpers.get((BlockGetter)level, (BlockPos)blockPos, BlockEntitySqueezer.class).ifPresent(tile -> {
                InventoryHelpers.dropItems((Level)level, (Container)tile.getInventory(), (BlockPos)blockPos);
                level.updateNeighbourForOutputSignal(blockPos, oldState.getBlock());
            });
            super.onRemove(oldState, level, blockPos, newState, isMoving);
        }
    }
}

