/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.api;

import com.google.common.base.Preconditions;
import io.github.lijinhong11.protector.api.ProtectionAPIPlugin;
import io.github.lijinhong11.protector.api.block.IBlockProtectionModule;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.CustomFlag;
import io.github.lijinhong11.protector.api.flag.FlagRegisterable;
import io.github.lijinhong11.protector.api.protection.FakeEventMaker;
import io.github.lijinhong11.protector.api.protection.IProtectionModule;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtectorAPI {
    private static final Set<IProtectionModule> modules = new CopyOnWriteArraySet<IProtectionModule>();
    private static final Set<IBlockProtectionModule> blockModules = new CopyOnWriteArraySet<IBlockProtectionModule>();
    private static ProtectionAPIPlugin pluginHost;

    public static void register(IProtectionModule module) {
        Preconditions.checkNotNull((Object)module, (Object)"module cannot be null");
        Preconditions.checkArgument((!modules.contains(module) ? 1 : 0) != 0, (Object)"module already registered");
        modules.add(module);
    }

    public static void register(IBlockProtectionModule module) {
        Preconditions.checkNotNull((Object)module, (Object)"block module cannot be null");
        Preconditions.checkArgument((!blockModules.contains(module) ? 1 : 0) != 0, (Object)"block module already registered");
        blockModules.add(module);
    }

    @ApiStatus.Internal
    public static void setPluginHost(ProtectionAPIPlugin plugin) {
        Preconditions.checkNotNull((Object)((Object)plugin), (Object)"plugin cannot be null");
        Preconditions.checkArgument((pluginHost == null ? 1 : 0) != 0, (Object)"plugin host already set");
        pluginHost = plugin;
    }

    public static ProtectionAPIPlugin getPluginHost() {
        return pluginHost;
    }

    @Nullable
    public static IProtectionModule getFirstAvailableModule() {
        return ((IProtectionModule[])modules.toArray(IProtectionModule[]::new))[0];
    }

    @Nullable
    public static IProtectionModule getModuleByPluginName(String pluginName) {
        for (IProtectionModule module : modules) {
            if (!module.getPluginName().equalsIgnoreCase(pluginName)) continue;
            return module;
        }
        return null;
    }

    public static void registerFlag(CustomFlag flag) {
        FlagRegisterable fr;
        for (IProtectionModule iProtectionModule : modules) {
            if (!(iProtectionModule instanceof FlagRegisterable)) continue;
            fr = (FlagRegisterable)((Object)iProtectionModule);
            fr.registerFlag(flag);
        }
        for (IBlockProtectionModule iBlockProtectionModule : blockModules) {
            if (!(iBlockProtectionModule instanceof FlagRegisterable)) continue;
            fr = (FlagRegisterable)((Object)iBlockProtectionModule);
            fr.registerFlag(flag);
        }
    }

    public static Collection<IProtectionModule> getAllAvailableProtectionModules() {
        return modules;
    }

    @Nullable
    public static IProtectionModule findModule(Location location) {
        for (IProtectionModule module : modules) {
            if (!module.isInProtectionRange(location)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public static IBlockProtectionModule findBlockModule(Player p, Location block) {
        for (IBlockProtectionModule module : blockModules) {
            if (!module.isProtected(p, block)) continue;
            return module;
        }
        return null;
    }

    public static boolean isEventFake(@NotNull Event event) {
        boolean fake = false;
        for (IBlockProtectionModule module : blockModules) {
            FakeEventMaker fem;
            if (!(module instanceof FakeEventMaker) || !(fake = (fem = (FakeEventMaker)((Object)module)).isEventFake(event))) continue;
            return true;
        }
        return fake;
    }

    public static boolean allowBreak(Player player) {
        Location location = player.getLocation();
        IProtectionModule module = ProtectorAPI.findModule(location);
        if (module == null) {
            for (IProtectionModule m2 : modules) {
                if (!m2.isSupportGlobalFlags()) continue;
                return (Boolean)Objects.requireNonNull(m2.getGlobalFlag(CommonFlags.BREAK, location.getWorld().getName())).value();
            }
            return true;
        }
        ProtectionRangeInfo info = module.getProtectionRangeInfo(player);
        if (info == null) {
            return true;
        }
        return (Boolean)info.getFlagState(CommonFlags.BREAK, (OfflinePlayer)player).value();
    }

    public static boolean allowBreak(Player player, Location block) {
        IBlockProtectionModule module = ProtectorAPI.findBlockModule(player, block);
        if (ProtectorAPI.allowBreak(player)) {
            if (module == null) {
                return true;
            }
            if (!module.allowBreak(player, block)) {
                return false;
            }
        }
        return false;
    }

    public static boolean allowPlace(Player player) {
        Location location = player.getLocation();
        IProtectionModule module = ProtectorAPI.findModule(location);
        if (module == null) {
            for (IProtectionModule m2 : modules) {
                if (!m2.isSupportGlobalFlags()) continue;
                return (Boolean)Objects.requireNonNull(m2.getGlobalFlag(CommonFlags.PLACE, location.getWorld().getName())).value();
            }
            return true;
        }
        ProtectionRangeInfo info = module.getProtectionRangeInfo(player);
        if (info == null) {
            return true;
        }
        return (Boolean)info.getFlagState(CommonFlags.PLACE, (OfflinePlayer)player).value();
    }

    public static boolean allowPlace(Player player, Location block) {
        IBlockProtectionModule module = ProtectorAPI.findBlockModule(player, block);
        if (ProtectorAPI.allowPlace(player)) {
            if (module == null) {
                return true;
            }
            if (!module.allowPlace(player, block)) {
                return false;
            }
        }
        return false;
    }

    public static boolean allowInteract(Player player) {
        Location location = player.getLocation();
        IProtectionModule module = ProtectorAPI.findModule(location);
        if (module == null) {
            for (IProtectionModule m2 : modules) {
                if (!m2.isSupportGlobalFlags()) continue;
                return (Boolean)Objects.requireNonNull(m2.getGlobalFlag(CommonFlags.INTERACT, location.getWorld().getName())).value();
            }
            return true;
        }
        ProtectionRangeInfo info = module.getProtectionRangeInfo(player);
        if (info == null) {
            return true;
        }
        return (Boolean)info.getFlagState(CommonFlags.INTERACT, (OfflinePlayer)player).value();
    }

    public static boolean allowInteract(Player player, Location block) {
        IBlockProtectionModule module = ProtectorAPI.findBlockModule(player, block);
        if (ProtectorAPI.allowInteract(player)) {
            if (module == null) {
                return true;
            }
            if (!module.allowInteract(player, block)) {
                return false;
            }
        }
        return false;
    }
}

