/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.api.flag;

import io.github.lijinhong11.protector.api.flag.IFlagState;
import org.jetbrains.annotations.Nullable;

public class FlagState {
    public static final IFlagState<Boolean> ALLOW = new SimpleFlagState<Boolean>(true);
    public static final IFlagState<Boolean> DENY = new SimpleFlagState<Boolean>(false);
    public static final IFlagState<Boolean> NOT_SET = new SimpleFlagState<Object>(null);
    public static final IFlagState<Object> UNSUPPORTED = new UnsupportedFlagState();
    public static final IFlagState<Object> WORLD_NOT_FOUND = new WorldNotFoundFlagState();

    private FlagState() {
    }

    public static IFlagState<Boolean> fromBoolean(boolean value) {
        return value ? ALLOW : DENY;
    }

    public static IFlagState<Boolean> fromNullableBoolean(@Nullable Boolean value) {
        if (value == null) {
            return NOT_SET;
        }
        return FlagState.fromBoolean(value);
    }

    public static <T> IFlagState<T> of(@Nullable T value) {
        return new SimpleFlagState<T>(value);
    }

    record SimpleFlagState<T>(T value) implements IFlagState<T>
    {
    }

    static class UnsupportedFlagState
    implements IFlagState<Object> {
        UnsupportedFlagState() {
        }

        @Override
        public Object value() {
            throw new UnsupportedOperationException();
        }
    }

    static class WorldNotFoundFlagState
    implements IFlagState<Object> {
        WorldNotFoundFlagState() {
        }

        @Override
        public Object value() {
            throw new UnsupportedOperationException();
        }
    }
}

