/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.block_impl.lands;

import io.github.lijinhong11.protector.api.ProtectorAPI;
import io.github.lijinhong11.protector.api.block.IBlockProtectionModule;
import io.github.lijinhong11.protector.api.flag.CustomFlag;
import io.github.lijinhong11.protector.api.flag.FlagRegisterable;
import io.github.lijinhong11.protector.block_impl.lands.ProtectorAPIManagedFlag;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.type.Flags;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.flags.type.parent.Flag;
import me.angeschossen.lands.api.land.LandWorld;
import me.angeschossen.lands.api.player.LandPlayer;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LandsBlockProtectionModule
implements IBlockProtectionModule,
FlagRegisterable {
    private final LandsIntegration api = LandsIntegration.of((Plugin)ProtectorAPI.getPluginHost());

    @Override
    @NotNull
    public String getPluginName() {
        return "Lands";
    }

    @Override
    public boolean isProtected(Player player, Location block) {
        LandWorld lw = this.getLandWorld(block);
        if (lw == null) {
            return false;
        }
        LandPlayer lp = this.api.getLandPlayer(player.getUniqueId());
        return !lw.hasRoleFlag(lp, block, Flags.BLOCK_BREAK, null, false);
    }

    @Override
    public boolean allowBreak(Player player, Location block) {
        LandWorld lw = this.getLandWorld(block);
        if (lw == null) {
            return false;
        }
        LandPlayer lp = this.api.getLandPlayer(player.getUniqueId());
        return !lw.hasRoleFlag(lp, block, Flags.BLOCK_BREAK, null, false);
    }

    @Override
    public boolean allowPlace(Player player, Location block) {
        LandWorld lw = this.getLandWorld(block);
        if (lw == null) {
            return false;
        }
        LandPlayer lp = this.api.getLandPlayer(player.getUniqueId());
        return !lw.hasRoleFlag(lp, block, Flags.BLOCK_PLACE, null, false);
    }

    @Override
    public boolean allowInteract(Player player, Location block) {
        LandWorld lw = this.getLandWorld(block);
        if (lw == null) {
            return false;
        }
        LandPlayer lp = this.api.getLandPlayer(player.getUniqueId());
        RoleFlag interact = Flags.getInteract((Block)block.getBlock());
        if (interact == null) {
            return this.allowPlace(player, block);
        }
        return !lw.hasRoleFlag(lp, block, interact, null, false);
    }

    private LandWorld getLandWorld(Location loc) {
        return this.api.getWorld(loc.getWorld());
    }

    @Override
    public void registerFlag(CustomFlag flag) {
        this.api.getFlagRegistry().register((Flag)new ProtectorAPIManagedFlag(flag));
    }
}

