/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.block_impl.quickshop;

import com.ghostchu.quickshop.api.QuickShopAPI;
import com.ghostchu.quickshop.api.shop.Shop;
import com.ghostchu.quickshop.api.shop.permission.BuiltInShopPermission;
import io.github.lijinhong11.protector.api.block.IBlockProtectionModule;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class QuickShopHikariProtection
implements IBlockProtectionModule {
    private final QuickShopAPI api = QuickShopAPI.getInstance();

    @Override
    @NotNull
    public String getPluginName() {
        return "QuickShop-Hikari";
    }

    @Override
    public boolean isProtected(Player player, Location block) {
        return this.getShop(block) != null;
    }

    @Override
    public boolean allowBreak(Player player, Location block) {
        return this.getShop(block) == null || this.getShop(block).playerAuthorize(player.getUniqueId(), BuiltInShopPermission.DELETE);
    }

    @Override
    public boolean allowPlace(Player player, Location block) {
        return true;
    }

    @Override
    public boolean allowInteract(Player player, Location block) {
        return this.getShop(block) == null || this.getShop(block).playerAuthorize(player.getUniqueId(), BuiltInShopPermission.PURCHASE);
    }

    private Shop getShop(Location block) {
        return this.api.getShopManager().getShop(block);
    }
}

