/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.bentobox;

import io.github.lijinhong11.protector.api.convertions.FlagMap;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.FlagsManager;

public class BentoBoxIslandInfo
implements ProtectionRangeInfo {
    private final Island island;

    public BentoBoxIslandInfo(Island island) {
        this.island = island;
    }

    @Override
    @NotNull
    public Map<String, IFlagState<?>> getFlags() {
        FlagMap flagMap = new FlagMap(this.island.getFlags(), i -> FlagState.fromBoolean(i >= 0));
        return Collections.unmodifiableMap(flagMap);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag) {
        return this.getFlagState(flag, null);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag, OfflinePlayer player) {
        FlagsManager manager = BentoBox.getInstance().getFlagsManager();
        Optional theFlagOptional = manager.getFlag(flag);
        if (theFlagOptional.isEmpty()) {
            return FlagState.UNSUPPORTED;
        }
        Flag theFlag = (Flag)theFlagOptional.get();
        if (player == null) {
            return FlagState.fromBoolean(this.island.isAllowed(theFlag));
        }
        User user = BentoBox.getInstance().getPlayers().getUser(player.getUniqueId());
        return FlagState.fromBoolean(this.island.isAllowed(user, theFlag));
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag) {
        return this.getFlagState(flag, null);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag, OfflinePlayer player) {
        if (flag.getForBentoBox() == null) {
            return FlagState.UNSUPPORTED;
        }
        return this.getFlagState(flag.getForBentoBox(), player);
    }

    @Override
    public List<OfflinePlayer> getAdmins() {
        return this.getMembers().stream().filter(m -> {
            User user = BentoBox.getInstance().getPlayers().getUser(m.getUniqueId());
            return this.island.getRank(user) >= 900;
        }).toList();
    }

    @Override
    public List<OfflinePlayer> getMembers() {
        return this.island.getMembers().keySet().stream().map(Bukkit::getOfflinePlayer).toList();
    }

    @Override
    @Nullable
    public OfflinePlayer getOwner() {
        return this.island.getOwner() == null ? null : Bukkit.getOfflinePlayer((UUID)this.island.getOwner());
    }
}

